<?php

namespace App\Helper;

use Exception;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

class JWTToken
{
   public static function createToken($email, $id): string
    {
        $key = env('JWT_KEY');
        $payload = [
            'iss' => 'Laravel_Token',
            'iat' => time(),
            'exp' => time() + 7200, // 2 hours
            'client_Email' => $email,
            'client_Id' => $id
        ];

        return JWT::encode($payload, $key, 'HS256');
    }

    public static function createTokenForSetPassword($client_Email): string
    {
        $key = env('JWT_KEY');
        $payload = [
            'iss' => 'Laravel_Token',
            'iat' => time(),
            'exp' => time() + 60 * 1,
            'client_Email' => $client_Email,
            'client_Id' => '0'
        ];

        return JWT::encode($payload, $key, 'HS256');
    }

    public static function VerifyToken($token): string|object
    {
        try {
            if (!$token) return 'unauthorized';

            $key = env('JWT_KEY');
            $decoded = JWT::decode($token, new Key($key, 'HS256'));

            return (object)[
                'client_Email' => $decoded->client_Email,
                'client_Id' => $decoded->client_Id
            ];
        } catch (Exception $e) {
            return 'unauthorized';
        }
    }
}
