<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\BlogComment;
use App\Models\Blog;

class BlogCommentController extends Controller
{
    // 🔹 Get all comments for a specific blog
    public function index($blogId)
    {
        $blog = Blog::with('comments')->findOrFail($blogId);
        return response()->json($blog->comments);
    }

    // 🔹 Store a new comment for a blog
    public function store(Request $request, $blogId)
    {
        $request->validate([
            'comment' => 'required|string',
            'name'    => 'required|string|max:255',
            'email'   => 'required|email',
            'website' => 'nullable|string|max:255',
        ]);

        $blog = Blog::findOrFail($blogId);

        $comment = new BlogComment([
            'comment' => $request->comment,
            'name'    => $request->name,
            'email'   => $request->email,
            'website' => $request->website,
        ]);

        $blog->comments()->save($comment);

        return response()->json([
            'message' => 'Comment added successfully!',
            'comment' => $comment
        ], 201);
    }
}