<?php

namespace App\Http\Controllers;
use App\Models\Category;
use Illuminate\Http\Request;

class CetegoryController extends Controller
{
   
        // ✅ Show create page
    public function categoryCreatePage(Request $request)
    {
        return view('admin.category.CategoryCreate');
    }

    // ✅ Get all pricing plans
    public function categoryList(Request $request)
    {
        $plans = Category::all();
        return response()->json($plans);
    }

    // ✅ Store new pricing plan
    public function storeCategory(Request $request)
{
    $request->validate([
        'name' => 'required|string|max:100',
        'image' => 'required|image|mimes:jpg,jpeg,png|max:2048',
        'status' => 'required|boolean',
    ]);

    $imageUrl = null;

    if ($request->hasFile('image')) {
        $imagePath = $request->file('image')->store('image', 'public');
        $imageUrl = url('storage/' . $imagePath); // ✅ full URL
    }

    $plan = Category::create([
        'name' => $request->input('name'),
        'image' => $imageUrl,
        'status' => $request->input('status'),
    ]);

    return response()->json([
        'message' => 'Category created successfully',
        'data' => $plan
    ], 201);
}


    // ✅ Edit single pricing plan
    public function editCategory(Request $request, $id)
    {
        $plan = Category::findOrFail($id);
        $plan->features = json_decode($plan->features); // ✅ decode for frontend
        return response()->json($plan);
    }

    // ✅ Update pricing plan
    public function updateCategory(Request $request, $id)
    {
        $request->validate([
        'name' => 'required|string|max:100',
        'image' => 'required|image|mimes:jpg,jpeg,png|max:2048',
        'status' => 'required|boolean',
    ]);

    if ($request->hasFile('image')) {
        $imagePath = $request->file('image')->store('image', 'public');
        $imageUrl = url('storage/' . $imagePath); // ✅ full URL
    }

    $plan = Category::findOrFail($id);
    $plan->update([
        'name' => $request->name,
        'image' => $imageUrl,
        'status' => $request->status,
    ]);

    return response()->json([
        'message' => 'Pricing plan updated successfully',
        'data' => $plan
    ]);

    }

    // ✅ Delete pricing plan
    public function deleteCategory(Request $request)
    {
        $id = $request->id;
        $plan = Category::findOrFail($id);
        $plan->delete();

        return response()->json([
            'message' => 'Pricing plan deleted successfully'
        ]);
    }

    // ✅ Toggle status
    public function updateCategoryStatus(Request $request)
    {
        $request->validate([
            'id' => 'required|integer|exists:categories,id',
            'status' => 'required|boolean',
        ]);

        $plan = Category::findOrFail($request->id);
        $plan->status = $request->status;
        $plan->save();

        return response()->json(['message' => 'Status updated successfully']);
    }

}
