<?php

namespace App\Http\Controllers;

use App\Helper\JWTToken;
use App\Mail\OTPMail;
use App\Models\Client;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

class ClientController extends Controller
{


    public function clientDetails(Request $request)
    {
        // Middleware বা header থেকে client_id পড়া
        $client_id = $request->header('id') ?? $request->input('client_id');

        if (!$client_id) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized: client_id missing',
            ], 401);
        }

        // Client খুঁজে বের করা
        $client = Client::find($client_id);

        if (!$client) {
            return response()->json([
                'status' => 'error',
                'message' => 'Client not found',
            ], 404);
        }

        // Client details JSON আকারে ফেরত দেওয়া
        return response()->json($client);
    }




    public function ClientList(Request $request, $client_id)
    {
        $count = Client::where('id', $client_id)->get();
        return response()->json( $count);
    }

    function ClientRegister( Request $request )
    {
        try{
           Client::create([
            'first_name' => request()->input('first_name'),
            'last_name' => request()->input('last_name'),
            'email' => request()->input('email'),
            'mobile' => request()->input('mobile'),
            'password' =>request()->input('password'),
        ]);


        return response()->json( ['status'=> 'Client Registered Successfully'] );
        }
        catch( \Exception $e ){
            return response()->json( ['status'=> 'Client Registration Failed', 'error'=> $e->getMessage()] );
        }

        
    }


function ClientLogin(Request $request){
    $count = Client::where('email', $request->input('email'))
        ->where('password', $request->input('password'))
        ->select('id')->first();

    if($count !== null){
        $token = JWTToken::createToken($request->input('email'), $count->id);

      return response()->json([
    'status' => 'success',
    'message' => 'User Login Successful'
], 200)->cookie(
    'token',
    $token,
    60*2,
    '/',
    '127.0.0.1',
    false,   // secure
    false,    // httpOnly
    'None'   // SameSite <-- THIS is correct for Laravel 10+
);
    } else {
        return response()->json([
            'status' => 'failed',
            'message' => 'unauthorized'
        ], 200);
    }
}



    function sendOtpCode(Request $request){
        $email = $request->input('email');
        $otp = rand(100000,999999);
        $count=Client::where('email','=',$email)->count();

        if($count==1){
            Mail::to($email)->send(new OTPMail($otp));
            Client::where('email','=',$email)->update(['otp'=>$otp]);


             return response()->json( [
                'status'=> 'success',
                'message' => 'Otp Code send to your E-mail Successfully',

            ],  );
        }
        else{
            return response()->json( [
                'status'=> 'Failed',
                'message' => 'unathorized'

            ],  );
        }

    }

    function verifyOtpCode(Request $request)
    {
        $email = $request->input('email');
        $otp = $request->input('otp');

        $user = Client::where('email', $email)->where('otp', $otp)->first();

        if ($user) {
            // Update OTP
            $user->update(['otp' => '0']);

            // Create JWT token
            $token = JWTToken::CreateTokenForSetPassword($email);

           return response()->json([
            'status' => 'success',
            'message' => 'OTP verified'
            ])->cookie('token', $token, 60*1, '/', null, true, true, false, 'Lax');
            
        } else {
            return response()->json([
                'status' => 'failed',
                'message' => 'Unauthorized',
            ], 401); // ✅ proper status code
        }
    }


    function ResetPassword(Request $request){
   try {
        $email = $request->header('email');
        $password = $request->input('password');

        Client::where('email', $email)->update(['password' => $password]);

        return response()->json([
            'status' => 'success',
            'message' => 'Password reset successful'
        ]);
    } catch (\Exception $exception) {
        return response()->json([
            'status' => 'fail',
            'message' => 'Something went wrong'
        ], 500);
    }

}




public function updateClientDetails(Request $request)
{
    $client_id = $request->header('id') ?? $request->input('client_id');

    if (!$client_id) {
        return response()->json([
            'status' => 'error',
            'message' => 'Unauthorized: client_id missing',
        ], 401);
    }

    $client = Client::find($client_id);

    if (!$client) {
        return response()->json([
            'status' => 'error',
            'message' => 'Client not found',
        ], 404);
    }

    try {
        $client->update([
            // Customer Info
            'cus_add'      => $request->input('cus_add'),
            'cus_city'     => $request->input('cus_city'),
            'cus_state'    => $request->input('cus_state'),
            'cus_postcode' => $request->input('cus_postcode'),
            'cus_country'  => $request->input('cus_country'),
            'cus_phone'    => $request->input('cus_phone'),
            'cus_fax'      => $request->input('cus_fax'),

            // Shipping Info
            'ship_name'     => $request->input('ship_name'),
            'ship_add'      => $request->input('ship_add'),
            'ship_city'     => $request->input('ship_city'),
            'ship_state'    => $request->input('ship_state'),
            'ship_postcode' => $request->input('ship_postcode'),
            'ship_country'  => $request->input('ship_country'),
            'ship_phone'    => $request->input('ship_phone'),
        ]);

        return response()->json([
            'status' => 'success',
            'message' => 'Client details updated successfully',
            'client' => $client
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'status' => 'error',
            'message' => 'Update failed',
            'error' => $e->getMessage()
        ], 500);
    }
}






}
