<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CouponDiscount;
use App\Mail\CouponMail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;
use App\Models\Cart;

class CouponController extends Controller
{
    public function sendCoupon(Request $request)
    {
        $client = Auth::user();
        if (!$client) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

        $existing = CouponDiscount::where('client_id', $client->id)->first();
        if ($existing) {
            return response()->json(['message' => 'Coupon already sent to this user'], 409);
        }

        $couponCode = 'SAVE10';

        CouponDiscount::create([
            'client_id' => $client->id,
            'coupon'    => $couponCode,
            'is_used'   => false,
        ]);

        if (!empty($client->email)) {
            Mail::to($client->email)->send(new CouponMail($couponCode));
        }

        return response()->json(['message' => 'Coupon sent to your email!']);
    }

    public function applyCoupon(Request $request)
    {
        $request->validate([
            'code'       => 'required|string',
            'cart_total' => 'required|numeric'
        ]);

        $client = Auth::user();
        if (!$client) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

        $coupon = CouponDiscount::where('client_id', $client->id)
                                ->where('coupon', $request->code)
                                ->where('is_used', false)
                                ->first();

        if (!$coupon) {
            return response()->json(['message' => 'Invalid or already used coupon'], 422);
        }

        $hasCartItems = Cart::where('client_id', $client->id)->exists();
        if (!$hasCartItems) {
            return response()->json(['message' => 'No cart found for this client'], 404);
        }

        $discount   = $request->cart_total * 0.10;
        $finalTotal = $request->cart_total - $discount;

        $coupon->update(['is_used' => true]);

        return response()->json([
            'message'     => 'Coupon applied successfully',
            'discount'    => $discount,
            'final_total' => $finalTotal
        ]);
    }
}