<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Client;
use App\Models\Invoice;
use App\Models\InvoiceProduct;
use App\Models\Cart;
use App\Models\CouponDiscount;
use Exception;
use Illuminate\Support\Facades\DB;
use App\Models\Order;

class InvoiceController extends Controller
{
    public function InvoiceCreate(Request $request)
    {
        DB::beginTransaction();
        try {
            $client_id    = $request->header('id');
            $client_Email = $request->header('email');

            $tran_id         = uniqid();
            $delivery_status = 'pending';
            $payment_status  = 'pending';

            $profile = Client::where('id', $client_id)->first();
            if (!$profile) {
                return response()->json(['message' => 'Client not found'], 404);
            }

            $cus_details  = "Name:$profile->first_name ,Address:$profile->cus_add,City:$profile->cus_city,Phone: $profile->cus_phone, postcode:$profile->cus_postcode";
            $ship_details = "Name:$profile->ship_name,Address:$profile->ship_add ,City:$profile->ship_city ,Phone: $profile->cus_phone, postcode:$profile->ship_postcode";

            // Calculate cart total (sum price * qty)
            $cartList = Cart::where('client_id', $client_id)->get();
            if ($cartList->isEmpty()) {
                return response()->json(['message' => 'Cart is empty'], 422);
            }

            $rawTotal = 0;
            foreach ($cartList as $cartItem) {
                $rawTotal += ($cartItem->price * $cartItem->qty);
            }

            // Determine final total
            $finalTotal = $rawTotal;

            // Path A: If frontend sent coupon_code, validate and apply
            if ($request->filled('coupon_code')) {
                $coupon = CouponDiscount::where('client_id', $client_id)
                                        ->where('coupon', $request->coupon_code)
                                        ->where('is_used', false)
                                        ->first();
                if ($coupon) {
                    $discount   = $rawTotal * 0.10;
                    $finalTotal = $rawTotal - $discount;
                    $coupon->update(['is_used' => true]);
                }
            }

            // Path B: If frontend already computed discounted total and sent `total`
            if ($request->filled('total')) {
                // Trust client-provided total only if it’s <= rawTotal
                $provided = floatval($request->total);
                if ($provided > 0 && $provided <= $rawTotal) {
                    $finalTotal = $provided;
                }
            }

            // VAT & Payable based on finalTotal
            $vat     = ($finalTotal * 3) / 100;
            $payable = $finalTotal + $vat;

            $invoice = Invoice::create([
                'total'           => $finalTotal,
                'vat'             => $vat,
                'payable'         => $payable,
                'cus_details'     => $cus_details,
                'ship_details'    => $ship_details,
                'tran_id'         => $tran_id,
                'delivery_status' => $delivery_status,
                'payment_status'  => $payment_status,
                'client_id'       => $client_id
            ]);

            $invoiceID = $invoice->id;

            foreach ($cartList as $EachProduct) {
                InvoiceProduct::create([
                    'invoice_id'  => $invoiceID,
                    'product_id'  => $EachProduct['product_id'],
                    'client_id'   => $client_id,
                    'quantity'    => $EachProduct['qty'],
                    'total_price' => $EachProduct['price'] * $EachProduct['qty'],
                    'size'        => $EachProduct['size'] ?? null,
                    'color'       => $EachProduct['color'] ?? null,
                ]);
            }

            DB::commit();

            return response()->json([
                'message' => 'Invoice created successfully',
                'total'   => $finalTotal,
                'vat'     => $vat,
                'payable' => $payable
            ], 201);

        } catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'message' => 'Invoice creation failed',
                'error'   => $e->getMessage()
            ], 500);
        }
    }


 public function confirmCODPaymentAndCreateOrder(Request $request)
{
    $invoice_id = $request->input('invoice_id');
    $client_id = $request->header('id'); // ✅ Make sure this is passed from frontend
    $payment_method = $request->input('payment_method') ?? 'COD';

    if (!$client_id) {
        return response()->json([
            'status' => 'error',
            'message' => 'Client ID missing in header'
        ], 400);
    }

    $invoice = Invoice::find($invoice_id);

    if (!$invoice) {
        return response()->json([
            'status' => 'error',
            'message' => 'Invoice not found'
        ], 404);
    }

    if ($invoice->payment_status !== 'COD') {
        $invoice->update(['payment_status' => 'COD']);
    }

    $order = Order::create([
        'invoice_id' => $invoice->id,
        'client_id' => $client_id,
        'payment_method' => $payment_method,
        'order_status' => 'confirmed',
        'delivery_status' => 'pending',
    ]);

    return response()->json([
        'status' => 'success',
        'message' => 'Payment confirmed and order created',
        'order_id' => $order->id,
        'invoice_id' => $invoice->id
    ]);
}



    public function pendingInvoicesByClient(Request $request)
{
    $client_id = $request->header('id');

    if (!$client_id) {
        return response()->json([
            'status' => 'error',
            'message' => 'Client ID missing from header'
        ], 401);
    }

    $invoices = Invoice::where('client_id', $client_id)
                       ->where('payment_status', 'pending')
                       ->orderBy('created_at', 'desc')
                       ->get();

    if ($invoices->isEmpty()) {
        return response()->json([
            'status' => 'info',
            'message' => 'No pending invoices found'
        ]);
    }

    return response()->json([
        'status' => 'success',
        'invoices' => $invoices
    ]);
}




}