<?php

namespace App\Http\Controllers;

use App\Models\Order;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public function show($id)
    {
        $order = Order::with(['invoice', 'client'])->findOrFail($id);
        return response()->json($order);
    }

    /**
     * অর্ডার ডিলিট করবে (header থেকে client_id নিয়ে)
     */
    public function destroy(Request $request)
    {
        $clientId = $request->header('client_id');

        if (!$clientId) {
            return response()->json([
                'message' => 'Client ID not provided in header'
            ], 400);
        }
        $order = Order::where('client_id', $clientId)->first();

        if (!$order) {
            return response()->json([
                'message' => 'Order not found for this client'
            ], 404);
        }

        $order->delete();

        return response()->json([
            'message' => 'Order deleted successfully'
        ]);
    }

    /**
     * অর্ডার গেট করবে (header থেকে client_id নিয়ে)
     */
    public function getByClient(Request $request)
    {
        $clientId = $request->header('id');

    if (!$clientId) {
        return response()->json([
            'message' => 'Client ID not provided in header'
        ], 400);
    }

    $orders = Order::with('invoice.invoiceProducts.product') // invoice details সহ
        ->where('client_id', $clientId)
        ->get();

    if ($orders->isEmpty()) {
        return response()->json([
            'message' => 'No orders found for this client'
        ], 404);
    }

    return response()->json($orders);

    }

    // order cancel and order status update
    public function OrderCancelAndupdate(Request $request, $id)
    {
        $order = Order::findOrFail($id);
        $order->order_status = $request->status;
        $order->save();

        return response()->json([
            'message' => 'Order status updated successfully'
        ]);
    }

    // getAllOrders
    public function getAllOrders()
    {
        // Order → Invoice → InvoiceProducts → Product
        $orders = Order::with('invoice.invoiceProducts.product')->get();

        return response()->json($orders);
    }

    // update delivery status 

    public function updateDeliveryStatus(Request $request)
{
    $request->validate([
        'id' => 'required|exists:orders,id',
        'delivery_status' => 'required|in:Pending,Processing,Completed'
    ]);

    $order = Order::findOrFail($request->id);
    $order->delivery_status = $request->delivery_status;
    $order->save();

    return response()->json([
        'success' => true,
        'message' => 'Delivery status updated successfully',
        'order' => $order
    ]);
}



}