<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Wishlist;
use Illuminate\Support\Facades\Log;

class WishController extends Controller
{
   public function WishStore(Request $request)
{
    // Validation
    $request->validate([
        'product_id' => 'required|integer|exists:products,id',
    ]);

    // Pull client_id from header or fallback
    $client_id = $request->header('id') ?? $request->input('client_id');

    if (!$client_id) {
        return response()->json([
            'status' => 'error',
            'message' => 'Unauthorized: client_id missing',
        ], 200); // ✅ 200 so frontend stays in try block
    }

    // ✅ Check if product already exists in wishlist
    $exists = Wishlist::where('client_id', $client_id)
                      ->where('product_id', $request->product_id)
                      ->exists();

    if ($exists) {
        return response()->json([
            'status' => 'error',
            'message' => 'Product already in wishlist',
        ], 200); // ✅ 200 so frontend handles it in try block
    }

    // Create wishlist item
    $wish = Wishlist::create([
        'client_id'  => $client_id,
        'product_id' => $request->product_id,
    ]);

    return response()->json([
        'status' => 'success',
        'message' => 'Product added to wishlist successfully',
        'data' => $wish,
    ], 201);
}




    public function wishCount(Request $request)
{
    // Get client_id from header
    $client_id = $request->header('id');

    if (!$client_id) {
        return response()->json([
            'status' => 'error',
            'message' => 'Client ID missing in header'
        ], 401);
    }

    // Count cart items for this client
    $count = Wishlist::where('client_id', $client_id)->count();

    return response()->json([
        'status' => 'success',
        'count' => $count
    ]);
}



// getWishByClientId

public function getWishByClient(Request $request)
{
    // Get client_id from header
    $client_id = $request->header('id');

    if (!$client_id) {
        return response()->json([
            'status' => 'error',
            'message' => 'Client ID missing in header'
        ], 401);
    }

    // Count cart items for this client
    $count = Wishlist::where('client_id', $client_id)->get();

    return response()->json( $count);
    
}



public function removeFromWish(Request $request)
    {
      try {
        $client_id = $request->header('id');

        if (!$client_id) {
            return response()->json([
                'status' => 'error',
                'message' => 'Client ID missing in header'
            ], 401);
        }

        $productId = $request->input('product_id');
        if (!$productId) {
            return response()->json(['message' => 'Product ID is required'], 400);
        }

        $deleted = Wishlist::where('client_id', $client_id)
                       ->where('product_id', $productId)
                       ->delete();

        if ($deleted) {
            return response()->json(['message' => '✅ Product removed from wish Successfull!'], 200);
        } else {
            return response()->json(['message' => 'Product not found in wish'], 404);
        }

    } catch (\Exception $e) {
        Log::error('Remove from wish failed: ' . $e->getMessage());
        return response()->json(['message' => 'Server error occurred'], 500);
    }

    }







}
