<?php

namespace App\Http\Middleware;

use App\Helper\JWTToken;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class TokenVerificationMiddleware
{
    public function handle(Request $request, Closure $next): Response
    {
        $token = $request->cookie('token');  
        $result = JWTToken::VerifyToken($token);

        if ($result === 'unauthorized') {
            return response()->json([
                'status' => 'failed',
                'message' => 'unauthorized'
            ], 401);
        }

        // Add decoded data to request headers
        $request->headers->set('email', $result->client_Email);
        $request->headers->set('id', $result->client_Id);

        return $next($request);
    }
}