<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CouponMail extends Mailable
{
    use Queueable, SerializesModels;

    public string $coupon;

    /**
     * Create a new message instance.
     */
    public function __construct(string $coupon)
    {
        $this->coupon = $coupon;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('Your Discount Coupon')
                    ->view('emails.coupon')
                    ->with(['coupon' => $this->coupon]);
    }
}