<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Brand extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'image',
        'status',
        'category_id',  // নতুন কলাম
    ];

    /**
     * Relation: একটি Brand একটি Category-এর অন্তর্ভুক্ত
     */
    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}