<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Cart extends Model
{
    use HasFactory;

    protected $fillable = [
        'client_id',
        'product_id',
        'qty',
        'price',
        'size',   // ✅ নতুন ফিল্ড
        'color',  // ✅ নতুন ফিল্ড
    ];

    // Relationships
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function client()
    {
        return $this->belongsTo(Client::class);
    }
}