<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    use HasFactory;
    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'mobile',
        'password',
        'otp',

        'cus_add',
        'cus_city',
        'cus_state',
        'cus_postcode',
        'cus_country',
        'cus_phone',
        'cus_fax',
        
        'ship_name',
        'ship_add',
        'ship_city',
        'ship_state',
        'ship_postcode',
        'ship_country',
        'ship_phone',
    ];
    protected $attributes = [
        'otp' => '0'
    ];

    public function carts() {
        return $this->hasMany(Cart::class);
    }

    public function wishlists() {
        return $this->hasMany(Wishlist::class);
    }
    public function reviews() {
        return $this->hasMany(Review::class);
    }
    public function invoices() {
        return $this->hasMany(Invoice::class);
    }
    public function invoice_products() {
        return $this->hasMany(InvoiceProduct::class);
    }

}
