<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    // টেবিলের নাম (Laravel ডিফল্টভাবে plural নেয়, তাই চাইলে বাদ দিতে পারো)
    protected $table = 'orders';

    // Mass assignment এর জন্য fillable ফিল্ডগুলো
    protected $fillable = [
    'invoice_id',
    'client_id',
    'payment_method',
    'order_status',
    'delivery_status',
    'total', // ✅ added
];
    // টাইমস্ট্যাম্পগুলোকে date হিসেবে কাস্ট করা
    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * রিলেশনশিপ: একটি অর্ডার একটি ইনভয়েসের সাথে যুক্ত
     */
    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }
    

    /**
     * রিলেশনশিপ: একটি অর্ডার একটি ক্লায়েন্টের সাথে যুক্ত
     */
    public function client()
    {
        return $this->belongsTo(Client::class);
    }
}