<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
    'name',
    'subtitle',
    'description',
    'price',
    'stock',
    'total_sales', // ✅ added
    'images',
    'status',
    'discount',
    'tag',
    'size',
    'colors',
    'category_id',
    'brand_id',
];

    protected $casts = [
        'images' => 'array',  // ✅ auto decode JSON to array
        'colors' => 'array',  // ✅ auto decode JSON to array
    ];

    // 🔗 Relationships
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function carts()
    {
        return $this->hasMany(Cart::class);
    }

    public function wishlists()
    {
        return $this->hasMany(Wishlist::class);
    }

    public function invoiceProducts()
    {
        return $this->hasMany(InvoiceProduct::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}