<?php

// app/Models/Review.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Review extends Model
{
    use HasFactory;

    protected $fillable = [
        'client_id',
        'product_id',
        'description',
        'rating',
    ];

    // ✅ Relationship added
    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }
}
