<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email')->unique();
            $table->string('mobile');
            $table->string('password');
            $table->string('otp');

            $table->string('cus_add',500)->nullable();
            $table->string('cus_city',50)->nullable();
            $table->string('cus_state',50)->nullable();
            $table->string('cus_postcode',50)->nullable();
            $table->string('cus_country',50)->nullable();
            $table->string('cus_phone',50)->nullable();
            $table->string('cus_fax',50)->nullable();

            $table->string('ship_name',100)->nullable();
            $table->string('ship_add',100)->nullable();
            $table->string('ship_city',100)->nullable();
            $table->string('ship_state',100)->nullable();
            $table->string('ship_postcode',100)->nullable();
            $table->string('ship_country',100)->nullable();
            $table->string('ship_phone',50)->nullable();

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clients');
    }
};
