<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('subtitle');
            $table->longText('description')->nullable();
            $table->decimal('price', 10, 2);
            $table->integer('stock')->default(0);
            $table->json('images')->nullable(); // ✅ multiple image support
            $table->boolean('status')->default(true);
            $table->string('discount')->nullable();
            $table->enum('tag', ['Latest', 'Top Rating', 'Best Selling', 'Featured','Special','Gift','Outher'])->nullable();
            // ✅ নতুন ফিল্ড
            $table->enum('size', ['XS','S','M','L','XL','XXL'])->nullable();
            $table->json('colors')->nullable(); // ✅ multiple color support

            $table->unsignedBigInteger('category_id');
            $table->unsignedBigInteger('brand_id');

            $table->foreign('category_id')->references('id')->on('categories')
                  ->cascadeOnUpdate()->restrictOnDelete();
            $table->foreign('brand_id')->references('id')->on('brands')
                  ->cascadeOnUpdate()->restrictOnDelete();

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};