<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('carts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('client_id'); // user who added to cart
            $table->unsignedBigInteger('product_id');
            $table->integer('qty')->default(1);
            $table->integer('price');

            // ✅ নতুন ফিল্ড
            $table->enum('size', ['XS','S','M','L','XL','XXL'])->nullable();
            $table->string('color')->nullable(); // একাধিক হলে json ব্যবহার করতে পারেন

            // Foreign keys
            $table->foreign('client_id')->references('id')->on('clients')
                ->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreign('product_id')->references('id')->on('products')
                ->cascadeOnUpdate()->cascadeOnDelete();

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('carts');
    }
};