<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Blog Name
            $table->string('title'); // Blog Title
            $table->json('descriptions')->nullable(); // ✅ Multiple descriptions as array
            $table->string('image'); // Blog Image URL
            $table->boolean('status')->default(true); // Active/Inactive
            $table->timestamps(); // created_at & updated_at
        });
    }

    public function down(): void {
        Schema::dropIfExists('blogs');
    }
};