<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('coupon_discounts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('client_id'); // link to clients table
            $table->string('coupon');
            $table->boolean('is_used')->default(false);
            $table->timestamps();

            // ✅ ঠিক foreign key relation
            $table->foreign('client_id')->references('id')->on('clients')->onDelete('cascade');
        });
    }

    public function down(): void {
        Schema::dropIfExists('coupon_discounts');
    }
};