<x-app-layout>
    <x-slot name="header">
        <h2 class="text-3xl font-bold text-gray-600">
            <span class="text-[#00FF7F]">Create</span> Blog
        </h2>
    </x-slot>

    <form id="blog-form"
          class="max-w-[50%] mx-auto mt-10 p-6 bg-gray-900 border border-[#00FF7F] rounded-lg shadow-lg"
          onsubmit="event.preventDefault(); submitBlog();">

        <!-- Blog Name -->
        <label for="name" class="block mb-2 text-sm font-medium text-gray-300">Blog Name</label>
        <input type="text" id="name" name="name"
               class="w-full mb-4 px-4 py-2 bg-transparent border border-gray-600 rounded text-gray-200 focus:border-[#00FF7F]"
               placeholder="Enter blog name" required>

        <!-- Blog Title -->
        <label for="title" class="block mb-2 text-sm font-medium text-gray-300">Blog Title</label>
        <input type="text" id="title" name="title"
               class="w-full mb-4 px-4 py-2 bg-transparent border border-gray-600 rounded text-gray-200 focus:border-[#00FF7F]"
               placeholder="Enter blog title" required>

        <!-- Descriptions -->
        <label class="block mb-2 text-sm font-medium text-gray-300">Descriptions</label>
        <div id="descriptions-container" class="space-y-3 mb-4">
            <textarea name="descriptions[]" class="w-full px-4 py-2 bg-transparent border border-gray-600 rounded text-gray-200" placeholder="Description 1" required></textarea>
        </div>
        <button type="button" onclick="addDescription()"
                class="text-[#00FF7F] text-sm font-medium hover:underline mb-4">+ Add More Descriptions</button>

        <!-- Upload Blog Image -->
        <label for="image" class="block mb-2 text-sm font-medium text-gray-300">Upload Blog Image</label>
        <div class="relative w-full h-40 border border-[#00FF7F] rounded bg-gray-800 flex items-center justify-center overflow-hidden mb-4">
            <img id="preview" class="absolute w-full h-full object-cover rounded hidden" />
            <label for="image" class="cursor-pointer text-5xl text-[#00FF7F] z-10">+</label>
            <input type="file" id="image" name="image" accept="image/*" class="hidden"
                   onchange="previewImage(this)">
        </div>

        <!-- Status -->
        <label for="status" class="block mb-2 text-sm font-medium text-gray-300">Status</label>
        <select id="status" name="status"
                class="w-full mb-6 px-4 py-2 bg-transparent border border-gray-600 rounded text-gray-200 focus:border-[#00FF7F]" required>
            <option value="1">Active</option>
            <option value="0">Inactive</option>
        </select>

        <!-- Submit Button -->
        <button type="submit"
                class="w-full py-2 px-4 bg-[#00FF7F] text-gray-900 font-bold rounded hover:bg-green-400 transition">
            Create
        </button>
    </form>

    <script>
        function addDescription() {
            const container = document.getElementById('descriptions-container');
            const textarea = document.createElement('textarea');
            textarea.name = 'descriptions[]';
            textarea.className = 'w-full px-4 py-2 bg-transparent border border-gray-600 rounded text-gray-200';
            textarea.placeholder = 'Description';
            container.appendChild(textarea);
        }

        function previewImage(input) {
            const file = input.files[0];
            const preview = document.getElementById('preview');

            if (file && file.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    preview.src = e.target.result;
                    preview.classList.remove('hidden');
                };
                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                preview.classList.add('hidden');
            }
        }

        async function submitBlog() {
            const form = document.getElementById('blog-form');
            const formData = new FormData(form);

            try {
                showLoader();
                let res = await axios.post("/blogStore", formData, {
                    headers: { 'Content-Type': 'multipart/form-data' }
                });
                hideLoader();

                if (res.status === 201) {
                    successToast('Blog created successfully!');
                    window.location.href = '/blog';
                } else {
                    errorToast("Request failed!");
                }
            } catch (error) {
                console.error("Error occurred while submitting the form: ", error);
                errorToast("An error occurred. Please try again.");
            }
        }
    </script>
</x-app-layout>