<x-app-layout>
    <x-slot name="header">
        <p class="text-3xl font-bold text-gray-500">
            <span class="text-[#00FF7F]">Category</span> Create
        </p>
    </x-slot>

    <form id="save-form" class="w-[40%] m-auto border mt-5 py-6 px-6 rounded border-[#00FF7F]" 
          onsubmit="event.preventDefault(); handleForm();">
        
        <!-- Name field -->
        <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" 
               type="text" id="name" name="name" placeholder="Category Name" required>
        

        <div class="relative w-full h-32 border border-[#00FF7F] mb-5 rounded bg-gray-900 flex items-center justify-center overflow-hidden">
            <!-- Preview Image -->
            <img id="preview" class="absolute w-full h-full object-cover rounded hidden" />

            <!-- Plus Icon -->
            <label for="image" class="cursor-pointer text-4xl text-[#00FF7F] z-10">+</label>
            <input type="file" id="image" name="image" accept="image/*" class="hidden"
                   onchange="previewImage(this)">
        </div>
        <!-- Status field -->
        <select id="status" name="status" 
                class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
            <option value="1">Active</option>
            <option value="0">Inactive</option>
        </select>

        <!-- Submit button -->
        <button type="submit" 
                class="border py-2 px-4 bg-[#00FF7F] text-gray-500 font-bold rounded hover:bg-[#00FF7F]">
            Create
        </button>
    </form>

    <script>

        function previewImage(input) {
            const file = input.files[0];
            const preview = document.getElementById('preview');

            if (file && file.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    preview.src = e.target.result;
                    preview.classList.remove('hidden');
                };
                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                preview.classList.add('hidden');
            }
        }

        async function handleForm() {
            // Get form data
            let name = document.getElementById('name').value;
            let image = document.getElementById('image').files[0];
            let status = document.getElementById('status').value;

            // Validate input fields
            if (!name || !image || status === "") {
                console.error('Error: All fields are required!');
                return;
            }

            // Create FormData object
            let formData = new FormData();
            formData.append('name', name);
            formData.append('image', image);
            formData.append('status', status);

            try {
                // Make POST request to the server
                let res = await axios.post("/categoryStore", formData, {
                    headers: {
                        'Content-Type': 'multipart/form-data'
                    }
                });

                // Handle success
                if (res.status === 201) {
                    successToast('Category created successfully!');
                    window.location.href = '/category'; // Redirect to category list page
                } else {
                    errorToast("Request failed!");
                }
            } catch (error) {
                console.error("Error occurred while submitting the form: ", error);
                errorToast("An error occurred. Please try again.");
            }
        }
    </script>
</x-app-layout>