<div class="container-fluid mt-4">
  <div class="row">
    <div class="col-md-12 col-sm-12 col-lg-12">
      <div class="px-5 py-5">
        <hr class="bg-secondary" />
        <div class="table-responsive">
          <table class="table" id="tableData">
            <thead>
              <tr class="bg-[#041819] text-white">
                <th>No</th>
                <th>invoice Id</th>
                <th>Total Amount</th>
                <th>Order Status</th>
                <th>Delivery Status</th>
                <th>Shipping</th>
                <th>Product Details</th>
                <th>Status</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody id="tableList"></tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
.switch {
  position: relative;
  display: inline-block;
  width: 50px;
  height: 24px;
}
.switch input {
  opacity: 0;
  width: 0;
  height: 0;
}
.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  transition: 0.4s;
  border-radius: 24px;
}
.slider:before {
  position: absolute;
  content: "";
  height: 18px;
  width: 18px;
  left: 3px;
  bottom: 3px;
  background-color: white;
  transition: 0.4s;
  border-radius: 50%;
}
input:checked + .slider {
  background-color: #00ff7f;
}
input:checked + .slider:before {
  transform: translateX(26px);
}
.status-label {
  font-size: 12px;
  margin-left: 8px;
  font-weight: bold;
  color: #888;
}
.status-label.active {
  color: #00ff7f;
}
.status-label.inactive {
  color: #ff4c4c;
}
</style>

<script>
getList();

async function getList() {
  let res = await axios.get("/ordersList");
  let tableList = $("#tableList");
  let tableData = $("#tableData");

  tableData.DataTable().destroy();
  tableList.empty();

  res.data.forEach(function (item, index) {
    let invoice = item.invoice;
    let productsHTML = "";

    if (invoice && invoice.invoice_products) {
      invoice.invoice_products.forEach((invProd) => {
        let product = invProd.product;
        productsHTML += `
          <div class="mb-2">
            <strong>${product?.name || "Unnamed Product"}</strong><br/>
            Quantity: ${invProd.quantity}<br/>
            Price: ${invProd.total_price}৳<br/>
            ${invProd.size ? `Size: ${invProd.size}<br/>` : ""}
            ${invProd.color ? `Color: ${invProd.color}<br/>` : ""}
          </div>
          <hr/>
        `;
      });
    } else {
      productsHTML = `<span class="text-muted">No products found</span>`;
    }

    let statusValue = item["status"] === "Inactive" ? "Inactive" : "Active";
    let isChecked = statusValue === "Active" ? "checked" : "";
    let statusText =
      statusValue === "Active" ? "Visible to Clients" : "Hidden from Clients";
    let statusClass = statusValue === "Active" ? "active" : "inactive";

   let row = `<tr data-id="${item["id"]}" class="text-wrap ${item.order_status === "Cancelled" ? "text-red-500 fw-bold" : ""}">
  <td>${index + 1}</td>
  <td class="text-wrap">${invoice?.id || "N/A"}</td>
  <td class="text-wrap">${invoice?.total || "N/A"}</td>
  <td>${item.order_status || "N/A"}</td>

  <!-- ✅ Delivery Status Select -->
  <td>
  <select onchange="updateDeliveryStatus(${item["id"]}, this.value)" class="form-select form-select-sm">
    <option value="Pending" ${item.delivery_status === "Pending" ? "selected" : ""}>Pending</option>
    <option value="Processing" ${item.delivery_status === "Processing" ? "selected" : ""}>Processing</option>
    <option value="Processing" ${item.delivery_status === "On The Way" ? "selected" : ""}>On The Way</option>
    <option value="Completed" ${item.delivery_status === "Completed" ? "selected" : ""}>Completed</option>
  </select>
</td>


  <td class="text-wrap">${invoice?.ship_details || "N/A"}</td>
  <td>${productsHTML}</td>
  <td>
    <label class="switch">
      <input type="checkbox" ${isChecked} onchange="toggleStatus(this, ${item["id"]})">
      <span class="slider"></span>
    </label>
    <span id="status-label-${item["id"]}" class="status-label ${statusClass}">
      ${statusText}
    </span>
  </td>
  <td>
    <button data-id="${item["id"]}" onclick="FillUpdateForm(${item["id"]})" class="btn editBtn btn-sm btn-outline-success">Edit</button>
    <button data-id="${item["id"]}" class="btn deleteBtn btn-sm btn-outline-danger">Delete</button>
  </td>
</tr>`;





    tableList.append(row);
  });

  $(".editBtn").on("click", async function () {
    let id = $(this).data("id");
    $("#updateID").val(id);
    $("#update-modal").modal("show");
  });

  $(".deleteBtn").on("click", function () {
    let id = $(this).data("id");
    $("#delete-modal").modal("show");
    $("#deleteID").val(id);
  });

  new DataTable("#tableData", {
    order: [[0, "asc"]],
    lengthMenu: [5, 10, 15, 20, 30],
  });
}

async function toggleStatus(checkbox, id) {
  let isActive = checkbox.checked;

  let label = document.getElementById(`status-label-${id}`);
  label.textContent = isActive ? "Visible to Clients" : "Hidden from Clients";
  label.classList.toggle("active", isActive);
  label.classList.toggle("inactive", !isActive);

  try {
    await axios.post("updateCategoryStatus", {
      id: id,
      status: isActive ? 1 : 0,
    });
  } catch (error) {
    console.error("Status update failed:", error);
  }
}


async function updateDeliveryStatus(id, status) {
  try {
    let res = await axios.post('/updateDeliveryStatus', {
      id: id,
      delivery_status: status
    });

    if (res.data.success) {
      console.log("Delivery status updated:", res.data.order.delivery_status);
      // চাইলে alert বা toast দেখাতে পারো
      // alert("Delivery status updated successfully!");
    }
  } catch (error) {
    console.error("Delivery status update failed:", error);
    alert("Failed to update delivery status");
  }
}

</script>