<x-app-layout>
    <x-slot name="header">
        <p class="text-3xl font-bold text-gray-500">
            <span class="text-[#00FF7F]">Slider</span> Create
        </p>
    </x-slot>

    <form id="save-form" class="w-[60%] m-auto border mt-5 py-6 px-6 rounded border-[#00FF7F]"
          onsubmit="event.preventDefault(); handleForm();">

        <!-- title field -->
        <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="text" id="title" name="title" placeholder="Slider Title" required>

        <!-- subtitle field -->
        <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="text" id="subtitle" name="subtitle" placeholder="Slider Subtitle">

        <!-- link field -->
        <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="text" id="link" name="link" placeholder="Slider Link">

        <!-- Image field -->
        <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="file" id="image" name="image" required>

        <!-- Category field -->
        <select id="category_id" name="category_id"
                class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
            <option value="">Select Category</option>
            @foreach($categories as $category)
                <option value="{{ $category->id }}">{{ $category->name }}</option>
            @endforeach
        </select>

        <!-- Status field -->
        <select id="status" name="status"
                class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
            <option value="1">Active</option>
            <option value="0">Inactive</option>
        </select>

        <!-- Submit button -->
        <button type="submit"
                class="border py-2 px-4 bg-[#00FF7F] text-gray-500 font-bold rounded hover:bg-[#00FF7F]">
            Create
        </button>
    </form>

    <script>
        async function handleForm() {
            let title = document.getElementById('title').value;
            let subtitle = document.getElementById('subtitle').value;
            let link = document.getElementById('link').value;
            let image = document.getElementById('image').files[0];
            let category_id = document.getElementById('category_id').value;
            let status = document.getElementById('status').value;

            if (!title || !image || !category_id || status === "") {
                errorToast('Error: Required fields missing!');
                return;
            }

            let formData = new FormData();
            formData.append('title', title);
            formData.append('subtitle', subtitle);
            formData.append('link', link);
            formData.append('image', image);
            formData.append('category_id', category_id);
            formData.append('status', status);

            try {
                let res = await axios.post("/sliderStore", formData, {
                    headers: { 'Content-Type': 'multipart/form-data' }
                });

                if (res.status === 201) {
                    successToast('Slider created successfully!');
                    window.location.href = '/slider';
                } else {
                    errorToast("Request failed!");
                }
            } catch (error) {
                console.error("Error occurred while submitting the form: ", error);
                errorToast("An error occurred. Please try again.");
            }
        }
    </script>
</x-app-layout>