<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-md-12 col-sm-12 col-lg-12">
            <div class="px-5 py-5">
                <hr class="bg-secondary"/>
                <div class="table-responsive">
                    <table class="table" id="tableData">
                        <thead>
                        <tr class="bg-[#041819] text-white">
                            <th>No</th>
                            <th>Title</th>
                            <th>Subtitle</th>
                            <th>Link</th>
                            <th>Image</th>
                            <th>Category_Id</th>
                             <th>Status</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody id="tableList"></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.switch {
  position: relative;
  display: inline-block;
  width: 50px;
  height: 24px;
}
.switch input {
  opacity: 0;
  width: 0;
  height: 0;
}
.slider {
  position: absolute;
  cursor: pointer;
  top: 0; left: 0;
  right: 0; bottom: 0;
  background-color: #ccc;
  transition: .4s;
  border-radius: 24px;
}
.slider:before {
  position: absolute;
  content: "";
  height: 18px; width: 18px;
  left: 3px; bottom: 3px;
  background-color: white;
  transition: .4s;
  border-radius: 50%;
}
input:checked + .slider {
  background-color: #00FF7F;
}
input:checked + .slider:before {
  transform: translateX(26px);
}
.status-label {
  font-size: 12px;
  margin-left: 8px;
  font-weight: bold;
  color: #888;
}
.status-label.active {
  color: #00FF7F;
}
.status-label.inactive {
  color: #FF4C4C;
}
</style>

<script>
getList();

async function getList() {
    let res = await axios.get("/sliderList");
    let tableList = $("#tableList");
    let tableData = $("#tableData");

    tableData.DataTable().destroy();
    tableList.empty();

    res.data.forEach(function (item, index) {
        // ✅ Default to Active if status is missing/null
        let statusValue = item['status'] === 'Inactive' ? 'Inactive' : 'Active';

        let isChecked = statusValue === 'Active' ? 'checked' : '';
        let statusText = statusValue === 'Active' ? 'Visible to Clients' : 'Hidden from Clients';
        let statusClass = statusValue === 'Active' ? 'active' : 'inactive';

        let row = `<tr data-id="${item['id']}">
            <td>${index + 1}</td>
            <td class="text-wrap">${item['title']}</td>
            <td class="text-wrap">${item['subtitle']}</td>
            <td class="text-wrap">${item['link']}</td>
            <td class="text-wrap"><img src="${item['image']}" alt="Slider Image" style="max-width: 100px; max-height: 100px;"></td>
            <td class="text-wrap">${item['category_id']}</td>
            <td>
                <label class="switch">
                    <input type="checkbox" ${isChecked} onchange="toggleStatus(this, ${item['id']})">
                    <span class="slider round"></span>
                </label>
                <span class="status-label ${statusClass}" id="status-label-${item['id']}">${statusText}</span>
            </td>
            <td>
                <button data-id="${item['id']}" onclick="FillUpdateForm(${item['id']})" class="btn editBtn btn-sm btn-outline-success">Edit</button>
                <button data-id="${item['id']}" class="btn deleteBtn btn-sm btn-outline-danger">Delete</button>
            </td>
        </tr>`;
        tableList.append(row);
    });

    $('.editBtn').on('click', async function () {
        let id = $(this).data('id');
        $('#updateID').val(id);
        $('#update-modal').modal('show');
    });

    $('.deleteBtn').on('click', function () {
        let id = $(this).data('id');
        $('#delete-modal').modal('show');
        $('#deleteID').val(id);
    });

    new DataTable('#tableData', {
        order: [[0, 'asc']],
        lengthMenu: [5, 10, 15, 20, 30]
    });
}

async function toggleStatus(checkbox, id) {
    let isActive = checkbox.checked;

    // Update status label text and color
    let label = document.getElementById(`status-label-${id}`);
    label.textContent = isActive ? 'Visible to Clients' : 'Hidden from Clients';
    label.classList.toggle('active', isActive);
    label.classList.toggle('inactive', !isActive);

    // Update status via API
    try {
        await axios.post('/updateSliderStatus', {
            id: id,
            status: isActive ? 1 : 0
        });

    } catch (error) {
        console.error('Status update failed:', error);
    }
}
</script>