<div class="modal animated zoomIn" id="update-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content bg-gray-800 text-white"> <!-- background color added here -->
            <div class="modal-header border-b border-gray-700">
                <h5 class="modal-title text-gray-400" id="exampleModalLabel">Update <span class="text-[#00FF7F]">Category List</span></h5>
            </div>
            <div class="modal-body">
                <form id="update-form">
                    <div class="container">
                        <div class="row">
                            <form id="save-form" class="w-[50%] m-auto border mt-9 py-6 px-4 rounded bg-[#010116]">
                                <!-- title field -->
                                <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" 
                                    type="text" id="title" name="title" placeholder=" Slider Title" required>

                                <!-- subtitle field -->
                                <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" 
                                    type="text" id="subtitle" name="subtitle" placeholder=" Slider Subtitle" required>

                                <!-- link field -->
                                <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" 
                                    type="text" id="link" name="link" placeholder=" Slider Link" required>

                                <!-- Image field -->
                                <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" 
                                    type="file" id="image" name="image" required>
                                    
                                <!-- Category field -->
                                <select id="category_id" name="category_id"
                                        class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
                                    <option value="">Select Category</option>
                                </select>


                                
                                <!-- Status field -->
                                <select id="status" name="status" 
                                        class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>


                                <input type="hidden" id="updateID">
                            </form>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer border-t border-gray-700">
                <button id="update-modal-close" class="btn bg-gradient-primary" data-bs-dismiss="modal" aria-label="Close">Close</button>
                <button onclick="Update()" id="update-btn" class="btn bg-[#00FF7F]">Update</button>
            </div>
        </div>
    </div>
</div>


<script>

    async function loadCategories() {
    try {
        let res = await axios.get('/categoryList');
        let categories = res.data;

        let categorySelect = document.getElementById('category_id');
        categorySelect.innerHTML = '<option value="">Select Category</option>'; // reset

        categories.forEach(cat => {
            let option = document.createElement('option');
            option.value = cat.id;
            option.textContent = cat.name;
            categorySelect.appendChild(option);
        });
    } catch (error) {
        console.error("Failed to load categories", error);
    }
}


async function FillUpdateForm(id) {

    try {
        await loadCategories();
        let res = await axios.get(`/editSlider/${id}`);
        let about = res.data;

        document.getElementById("title").value = about.title;
        document.getElementById("subtitle").value = about.subtitle;
        document.getElementById("link").value = about.link;
        document.getElementById("status").value = about.status;
        document.getElementById("category_id").value = about.category_id; // ✅ set category
        document.getElementById("updateID").value = about.id;
    } catch (error) {
        console.error("Failed to fetch slider details", error);
    }
}

async function Update() {
    document.getElementById('update-modal-close').click();
    let updateID = document.getElementById('updateID').value;

    const formData = new FormData();
    formData.append('title', document.getElementById('title').value);
    formData.append('subtitle', document.getElementById('subtitle').value);
    formData.append('link', document.getElementById('link').value);
    formData.append('image', document.getElementById('image').files[0]);
    formData.append('status', document.getElementById('status').value);
    formData.append('category_id', document.getElementById('category_id').value); // ✅ send category

    try {
        let res = await axios.post(`/updateSlider/${updateID}`, formData, {
            headers: { 'Content-Type': 'multipart/form-data' }
        });
        successToast('Slider updated successfully!');
        await getList();
        window.location.href = '/slider';
    } catch {
        errorToast('Slider Update failed!');
    }
}




</script>
