<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>CBAIT :: Admin_Panel</title>

    <link rel="icon" type="image/png" href="{{ asset('favicon.png') }}">
    <link rel="shortcut icon" href="{{ asset('favicon.ico') }}" type="image/x-icon">
    <link rel="icon" type="image/x-icon" href="{{asset('/favicon.ico')}}" />

    <!-- External CSS -->
    <link href="{{asset('css/bootstrap.css')}}" rel="stylesheet" />
    <link href="{{asset('css/animate.min.css')}}" rel="stylesheet" />
    <link href="{{asset('css/fontawesome.css')}}" rel="stylesheet" />
    <link href="{{asset('css/style.css')}}" rel="stylesheet" />
    <link href="{{asset('css/toastify.min.css')}}" rel="stylesheet" />
    <link href="{{asset('css/jquery.dataTables.min.css')}}" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">

    <!-- JS Libraries -->
    <script src="{{asset('js/jquery-3.7.0.min.js')}}"></script>
    <script src="{{asset('js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('js/toastify-js.js')}}"></script>
    <script src="{{asset('js/axios.min.js')}}"></script>
    <script src="{{asset('js/config.js')}}"></script>
    <script src="{{asset('js/bootstrap.bundle.js')}}"></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Vite Assets -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="font-sans antialiased bg-black text-green-400">

    <!-- Loader -->
    <div id="loader" class="LoadingOverlay d-none">
        <div class="Line-Progress">
            <div class="indeterminate"></div>
        </div>
    </div>

    <!-- Layout -->
    <div class="min-h-screen flex flex-col">

        <!-- ✅ Top Header -->
        <header class="bg-gray-900 text-green-300 flex justify-between items-center px-6 py-4 shadow-md sticky top-0 z-50">
            <a href="{{ route('dashboard') }}" class="flex items-center gap-2">
                <span class="font-bold text-lg text-[#00a63e]">DevPolashStore</span>
            </a>

            <x-dropdown align="right" width="48">
                <x-slot name="trigger">
                    <!-- <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-[#00FF00] bg-black hover:text-[#FF8A1C] focus:outline-none transition ease-in-out duration-150">
                        <div>{{ Auth::user()->name }}</div>
                        <div class="ms-1">
                            <i class="fa-solid fa-chevron-down text-[#FF8A1C]"></i>
                        </div>
                    </button> -->
                    <img src={{ asset('logo.jpg') }} alt="Logo" class="h-10 w-auto rounded-full cursor-pointer">
                </x-slot>

                <x-slot name="content">
                    <x-dropdown-link :href="route('profile.edit')" class="text-[#00FF00] hover:text-[#00a63e]">
                        {{ __('Profile') }}
                    </x-dropdown-link>
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <x-dropdown-link :href="route('logout')" class="text-[#FF0000] hover:text-[#00a63e]"
                            onclick="event.preventDefault(); this.closest('form').submit();">
                            {{ __('Log Out') }}
                        </x-dropdown-link>
                    </form>
                </x-slot>
            </x-dropdown>
        </header>

        <!-- ✅ Main Content Area -->
        <div class="flex flex-1 h-screen">
            <!-- Sidebar (scrollable, pinned) -->
            <aside class="w-[20%] bg-gray-900 text-green-300 sticky top-[72px] h-[calc(100vh-72px)] overflow-y-auto border-r border-gray-800">
                @include('layouts.navigation')
            </aside>

            <!-- Page Content (scrollable) -->
            <div class="w-[80%] bg-black overflow-y-auto h-[calc(100vh-72px)]">
                @if (isset($header))
                    <div class="bg-gray-800 px-6 py-4 text-green-500 font-bold">
                        {{ $header }}
                    </div>
                @endif

                <main class="px-6 pb-10 text-green-300">
                    {{ $slot }}
                </main>
            </div>
        </div>
    </div>

    <!-- Tailwind CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.tailwindcss.com?plugins=forms,typography,aspect-ratio,line-clamp,container-queries"></script>
</body>
</html>