<nav x-data="{ open: false }" class="mt-3">
    <!-- Primary Navigation Menu -->
    <div class="mx-auto px-4 sm:px-6 lg:px-8">
        <div class="justify-between h-16">

            <div class="mb-4">
                <!-- Navigation Links -->

                <!-- Dashboard -->
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex mb-4">
                    <x-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')" class="text-[#FF8A1C] hover:text-[#00a63e]">
                        <i class="fa-solid fa-gauge me-2"></i> {{ __('Dashboard') }}
                    </x-nav-link>
                </div>

                <!-- Category -->
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex mb-4">
                    <x-nav-link :href="route('category')" :active="request()->routeIs('category')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                        <i class="fa-solid fa-layer-group me-2"></i> {{ __('Category') }}
                    </x-nav-link>
                </div>

                <!-- Brand -->
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex mb-4">
                    <x-nav-link :href="route('brand')" :active="request()->routeIs('brand')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                        <i class="fa-solid fa-tags me-2"></i> {{ __('Brand') }}
                    </x-nav-link>
                </div>

                <!-- Product -->
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex mb-4">
                    <x-nav-link :href="route('product')" :active="request()->routeIs('product')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                        <i class="fa-solid fa-box-open me-2"></i> {{ __('Product') }}
                    </x-nav-link>
                </div>

                <!-- Slider -->
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex mb-4">
                    <x-nav-link :href="route('slider')" :active="request()->routeIs('slider')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                        <i class="fa-solid fa-images me-2"></i> {{ __('Slider') }}
                    </x-nav-link>
                </div>

                <!-- Blog -->
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex mb-4">
                    <x-nav-link :href="route('blog')" :active="request()->routeIs('blog')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                        <i class="fa-solid fa-blog me-2"></i> {{ __('Blog') }}
                    </x-nav-link>
                </div>
                <!-- order -->
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex mb-4">
                    <x-nav-link :href="route('order')" :active="request()->routeIs('order')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                        <i class="fa-solid fa-box me-2"></i> {{ __('Orders') }}
                    </x-nav-link>
                </div>

                <!-- invoice -->
                <!-- <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex mb-4">
                    <x-nav-link :href="route('order')" :active="request()->routeIs('order')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                        <i class="fa-solid fa-file-invoice-dollar me-2"></i> {{ __('Invoice') }}
                    </x-nav-link>
                </div> -->

            </div>

            <!-- Hamburger -->
            <div class="-me-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-[#00FF00] hover:text-[#FF8A1C] hover:bg-gray-800 focus:outline-none focus:bg-gray-800 focus:text-[#FFFFFF] transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden bg-black">
        <div class="pt-2 pb-3 space-y-1">
            <x-responsive-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')" class="text-[#00FF00] hover:text-[#FF8A1C]">
                <i class="fa-solid fa-gauge me-2"></i> {{ __('Dashboard') }}
            </x-responsive-nav-link>
            <x-responsive-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')" class="text-[#00FF00] hover:text-[#FF8A1C]">
                <i class="fa-solid fa-gauge me-2"></i> {{ __('Order') }}
            </x-responsive-nav-link>
            <x-responsive-nav-link :href="route('category')" :active="request()->routeIs('category')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                <i class="fa-solid fa-layer-group me-2"></i> {{ __('Category') }}
            </x-responsive-nav-link>
            <x-responsive-nav-link :href="route('brand')" :active="request()->routeIs('brand')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                <i class="fa-solid fa-tags me-2"></i> {{ __('Brand') }}
            </x-responsive-nav-link>
            <x-responsive-nav-link :href="route('product')" :active="request()->routeIs('product')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                <i class="fa-solid fa-box-open me-2"></i> {{ __('Product') }}
            </x-responsive-nav-link>
            <x-responsive-nav-link :href="route('slider')" :active="request()->routeIs('slider')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                <i class="fa-solid fa-images me-2"></i> {{ __('Slider') }}
            </x-responsive-nav-link>
            <x-responsive-nav-link :href="route('blog')" :active="request()->routeIs('blog')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                <i class="fa-solid fa-blog me-2"></i> {{ __('Blog') }}
            </x-responsive-nav-link>
            <x-responsive-nav-link :href="route('order')" :active="request()->routeIs('order')" class="text-[#FFFFFF] hover:text-[#00FF00]">
                <i class="fa-solid fa-blog me-2"></i> {{ __('Orders') }}
            </x-responsive-nav-link>
        </div>

        <!-- Responsive Settings Options -->
        <div class="pt-4 pb-1 border-t border-green-700">
            <div class="px-4">
                <div class="font-medium text-base text-[#00FF00]">{{ Auth::user()->name }}</div>
                <div class="font-medium text-sm text-[#FF8A1C]">{{ Auth::user()->email }}</div>
            </div>

            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('profile.edit')" class="text-[#00FF00] hover:text-[#FF8A1C]">
                    <i class="fa-solid fa-user me-2"></i> {{ __('Profile') }}
                </x-responsive-nav-link>

                <!-- Authentication -->
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <x-responsive-nav-link :href="route('logout')" class="text-[#FF0000] hover:text-[#FFFFFF]"
                        onclick="event.preventDefault(); this.closest('form').submit();">
                        <i class="fa-solid fa-right-from-bracket me-2"></i> {{ __('Log Out') }}
                    </x-responsive-nav-link>
                </form>
            </div>
        </div>
    </div>
</nav>