<?php
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CetegoryController;
use App\Http\Controllers\BrandController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ReviewController;
use App\Http\Middleware\TokenVerificationMiddleware;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\ClientController;
use Illuminate\Http\Request;
use App\Helper\JWTToken;
use App\Models\Review;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\CartController;
use App\Http\Controllers\WishController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\BlogCommentController;
use App\Http\Controllers\CouponController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\DashboardController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Route::post('/clientRegister', [ClientController::class, 'ClientRegister'])->name('clientRegister');
Route::post('/clientLogin', [ClientController::class, 'ClientLogin'])->name('clientLogin');
Route::post('/sendOtpCode', [ClientController::class, 'sendOtpCode'])->name('sendOtpCode');
Route::post('/verifyOtpCode', [ClientController::class, 'verifyOtpCode'])->name('verifyOtpCode');
Route::post('/resetPassword', [ClientController::class, 'resetPassword'])->name('resetPassword')->middleware([TokenVerificationMiddleware::class]);
Route::get('/clientList/{client_id}', [ClientController::class, 'ClientList'])->name('clientList');
Route::get('/client/details', [ClientController::class, 'clientDetails'])->middleware(TokenVerificationMiddleware::class);
Route::post('/update_client_address', [ClientController::class, 'updateClientDetails'])->middleware(TokenVerificationMiddleware::class);

// Route::post('/logout', [ClientController::class, 'logout'])->name('logout');

// Route::get('/checkLogin', function (Request $request) {
//     $token = $request->cookie('token');
//     \Log::info('Token from cookie: ' . $token); // ✅ debug line

//     $result = JWTToken::VerifyToken($token);

//     return response()->json([
//         'isLoggedIn' => $result !== 'unauthorized'
//     ], 200);
// });





Route::get('/', [AuthenticatedSessionController::class, 'create']);

Route::post('/login', [AuthenticatedSessionController::class, 'store'])->name('login');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');
Route::get('/category', function () {
    return view('category');
})->middleware(['auth', 'verified'])->name('category');

Route::get('/brand', function () {
    return view('brand');
})->middleware(['auth', 'verified'])->name('brand');

Route::get('/product', function () {
    return view('product');
})->middleware(['auth', 'verified'])->name('product');

Route::get('/slider', function () {
    return view('slider');
})->middleware(['auth', 'verified'])->name('slider');

Route::get('/blog', function () {
    return view('bolg');
})->middleware(['auth', 'verified'])->name('blog');

Route::get('/order', function () {
    return view('order');
})->middleware(['auth', 'verified'])->name('order');



// Route::get('/dashboard', [DashboardController::class, 'index'])
//     ->middleware(['auth'])
//     ->name('dashboard');


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::middleware('auth')->group(function (){
    Route::post('/categoryStore', [CetegoryController::class, 'storeCategory'])->name('categoryStore');
    Route::post('/brandStore', [BrandController::class, 'storeBrand'])->name('brandStore');
    Route::post('/productStore', [ProductController::class, 'storeProduct'])->name('productStore');
    Route::post('/sliderStore', [SliderController::class, 'storeSlider'])->name('sliderStore');
    Route::post('/blogStore', [BlogController::class, 'store'])->name('blogStore');
    // Add a new comment to a blog
    
        
});
require __DIR__.'/auth.php';


// Category Routes
Route::get('/categoryCreatePage', [CetegoryController::class, 'categoryCreatePage'])->name('categoryCreatePage');
Route::get('/categoryList', [CetegoryController::class, 'categoryList'])->name('categoryList');
Route::post('/updateCategory/{id}', [CetegoryController::class, 'updateCategory'])->name('updateCategory');
Route::get('/editCategory/{id}', [CetegoryController::class, 'editCategory'])->name('editCategory');
Route::post('/deleteCategory', [CetegoryController::class, 'deleteCategory'])->name('deleteCategory');
Route::post('/updateCategoryStatus', [CetegoryController::class, 'updateCategoryStatus'])->name('updateCategoryStatus');

// Brand Routes
Route::get('/brandCreatePage', [BrandController::class, 'brandCreatePage'])->name('brandCreatePage');
Route::get('/brandList', [BrandController::class, 'brandList'])->name('brandList');
Route::post('/updateBrand/{id}', [BrandController::class, 'updateBrand'])->name('updateBrand');
Route::get('/editBrand/{id}', [BrandController::class, 'editBrand'])->name('editBrand');
Route::post('/deleteBrand', [BrandController::class, 'deleteBrand'])->name('deleteBrand');
Route::post('/updateBrandStatus', [BrandController::class, 'updateBrandStatus'])->name('updateBrandStatus');


// Product Routes
Route::get('/productCreatePage', [ProductController::class, 'productCreatePage'])->name('productCreatePage');
Route::get('/productList', [ProductController::class, 'productList'])->name('productList');
Route::post('/updateProduct/{id}', [ProductController::class, 'updateProduct'])->name('updateProduct');
Route::get('/editProduct/{id}', [ProductController::class, 'editProduct'])->name('editProduct');
Route::post('/deleteProduct', [ProductController::class, 'deleteProduct'])->name('deleteProduct');
Route::post('/updateProductStatus', [ProductController::class, 'updateProductStatus'])->name('updateProductStatus');
Route::get('/searchProducts', [ProductController::class, 'searchProducts']);



// Review Routes
Route::post('/storeReview', [ReviewController::class, 'storeReview'])->middleware(TokenVerificationMiddleware::class);
Route::get('/reviewList/{product_id}', [ReviewController::class, 'reviewList']);
Route::get('/reviewList', [ReviewController::class , 'getReviewList']);
// review Count
Route::get('/reviewCount/{product_id}', [ReviewController::class, 'reviewCount'])->name('reviewCount');
Route::get('/getReviewByClientID', [ReviewController::class, 'getReviewByClientID'])->name('getReviewByClientID')->middleware(TokenVerificationMiddleware::class);



// Slider Routes
Route::get('/sliderCreatePage', [SliderController::class, 'sliderCreatePage'])->name('sliderCreatePage');
Route::get('/sliderList', [SliderController::class, 'sliderList'])->name('sliderList');
Route::post('/updateSlider/{id}', [SliderController::class, 'updateSlider'])->name('updateSlider');
Route::get('/editSlider/{id}', [SliderController::class, 'editSlider'])->name('editSlider');
Route::post('/deleteSlider', [SliderController::class, 'deleteSlider'])->name('deleteSlider');
Route::post('/updateSliderStatus', [SliderController::class, 'updateSliderStatus'])->name('updateSliderStatus');

// Select Product by ID
Route::get('/selectProductbyId/{id}', [ProductController::class, 'selectProductbyId'])->name('selectProductbyId');
// Select Product by brand ID
Route::get('/relatedByBrand/{product_id}', [ProductController::class, 'relatedByBrand'])->name('relatedByBrand');

Route::get('/getProductById/{id}', [ProductController::class, 'getProductById'])->name('getProductById');
    // image select
Route::get('/products/{id}/images', [ProductController::class, 'showProductImage']);



// Add to Cart Route
Route::post('/storeCart', [CartController::class, 'storeCart'])->name('storeCart')->middleware(TokenVerificationMiddleware::class);
Route::get('/cartCount', [CartController::class, 'cartCount'])->middleware(TokenVerificationMiddleware::class);
Route::get('/getCartByClient', [CartController::class, 'getCartByClient'])->middleware(TokenVerificationMiddleware::class);
Route::post('/removeFromCart', [CartController::class, 'removeFromCart'])->middleware(TokenVerificationMiddleware::class);

// WishList Route
Route::post('/wishStore', [WishController::class, 'WishStore'])->middleware(TokenVerificationMiddleware::class);
Route::get('/wishCount', [WishController::class, 'wishCount'])->middleware(TokenVerificationMiddleware::class);
Route::get('/getWishByClient', [WishController::class, 'getWishByClient'])->middleware(TokenVerificationMiddleware::class);
Route::post('/removeFromWish', [WishController::class, 'removeFromWish'])->middleware(TokenVerificationMiddleware::class);


// invoice

Route::post('/invoice/create', [InvoiceController::class, 'InvoiceCreate'])->middleware(TokenVerificationMiddleware::class);



// blog api

Route::get('/blogCreatePage', [BlogController::class, 'create'])->name('blogCreatePage');
Route::get('/blogList', [BlogController::class, 'index'])->name('blogList');
Route::post('/updateBlog/{id}', [BlogController::class, 'update'])->name('updateBlog');
Route::post('/destroyBlog', [BlogController::class, 'destroy'])->name('destroy');
Route::get('/editBlog/{id}', [BlogController::class, 'edit'])->name('editBlog');
Route::get('/getBlodById/{id}', [BlogController::class, 'show'])->name('getBlodById');


// Blog Comment

// Get all comments for a blog
Route::get('/blog/{id}/comments', [BlogCommentController::class, 'index']);
Route::post('/blogs/{id}/comments', [BlogCommentController::class, 'store']);



Route::post('/coupon/send', [CouponController::class, 'sendCoupon'])->middleware(TokenVerificationMiddleware::class);
Route::post('/coupon/apply', [CouponController::class, 'applyCoupon'])->middleware(TokenVerificationMiddleware::class);


// Order Route
Route::post('/orders/{id}/cancel', [OrderController::class, 'OrderCancelAndupdate'])->middleware(TokenVerificationMiddleware::class);

// Route::post('/payment_store', [OrderController::class, 'store'])->middleware(TokenVerificationMiddleware::class);

Route::post('/payment/cod/confirm-order', [InvoiceController::class, 'confirmCODPaymentAndCreateOrder'])->middleware(TokenVerificationMiddleware::class);
Route::get('/invoices/pending', [InvoiceController::class, 'pendingInvoicesByClient'])->middleware(TokenVerificationMiddleware::class);

Route::get('/orders', [OrderController::class, 'getByClient'])->middleware(TokenVerificationMiddleware::class);
Route::get('/ordersList', [OrderController::class, 'getAllOrders'])->name('ordersList');
Route::post('/updateDeliveryStatus', [OrderController::class, 'updateDeliveryStatus']);





// Contact Route

// Route::get('/contact', [ContactController::class, 'index'])->name('contact');
Route::post('/sendMessage', [ContactController::class, 'sendMessage']);