<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <p class="text-3xl font-bold text-gray-500">
            <span class="text-[#00FF7F]">Brand</span> Create
        </p>
     <?php $__env->endSlot(); ?>

    <form id="save-form"
          class="w-full max-w-[50%] mx-auto border mt-6 py-6 px-6 rounded border-[#00FF7F] bg-transparent shadow-md"
          onsubmit="event.preventDefault(); handleForm();">

        <!-- Brand Name -->
        <label for="name" class="block mb-2 text-sm font-medium text-gray-600">Brand Name</label>
        <input class="block w-full mb-4 bg-transparent border border-gray-300 rounded focus:border-[#00FF7F] text-gray-700 px-3 py-2"
               type="text" id="name" name="name" placeholder="Enter brand name" required>

        <!-- Upload Brand Logo -->
        <label for="image" class="block mb-2 text-sm font-medium text-gray-600">Upload Brand Logo</label>
        <div class="relative w-full h-32 border border-[#00FF7F] rounded bg-gray-900 flex items-center justify-center overflow-hidden">
            <!-- Preview Image -->
            <img id="preview" class="absolute w-full h-full object-cover rounded hidden" />

            <!-- Plus Icon -->
            <label for="image" class="cursor-pointer text-4xl text-[#00FF7F] z-10">+</label>
            <input type="file" id="image" name="image" accept="image/*" class="hidden"
                   onchange="previewImage(this)">
        </div>

        <!-- Status -->
        <label for="status" class="block mt-4 mb-2 text-sm font-medium text-gray-600">Status</label>
        <select id="status" name="status"
                class="block w-full mb-4 bg-transparent border border-gray-300 rounded focus:border-[#00FF7F] text-gray-700 px-3 py-2" required>
            <option value="1">Active</option>
            <option value="0">Inactive</option>
        </select>

        <!-- ✅ Category Dropdown -->
        <label for="category_id" class="block mt-4 mb-2 text-sm font-medium text-gray-600">Select Category</label>
        <select id="category_id" name="category_id"
                class="block w-full mb-6 bg-transparent border border-gray-300 rounded focus:border-[#00FF7F] text-gray-700 px-3 py-2" required>
            <option value="">Select Category</option>
        </select>

        <!-- Submit Button -->
        <button type="submit"
                class="w-full py-2 px-4 bg-[#00a63e] text-gray-800 font-bold rounded hover:bg-green-400 transition duration-300">
            Create
        </button>
    </form>

    <!-- Preview & Form Script -->
    <script>
        // ✅ Preview Image
        function previewImage(input) {
            const file = input.files[0];
            const preview = document.getElementById('preview');

            if (file && file.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    preview.src = e.target.result;
                    preview.classList.remove('hidden');
                };
                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                preview.classList.add('hidden');
            }
        }

        // ✅ Load Categories from API
        async function loadCategories() {
            try {
                let res = await axios.get('/categoryList');
                let categories = res.data;

                let categorySelect = document.getElementById("category_id");
                categorySelect.innerHTML = '<option value="">Select Category</option>';

                categories.forEach(cat => {
                    let option = document.createElement("option");
                    option.value = cat.id;
                    option.text = cat.name;
                    categorySelect.appendChild(option);
                });
            } catch (error) {
                console.error("Failed to fetch categories", error);
            }
        }

        // ✅ Handle Form Submit
        async function handleForm() {
            let name = document.getElementById('name').value;
            let image = document.getElementById('image').files[0];
            let status = document.getElementById('status').value;
            let category_id = document.getElementById('category_id').value;

            if (!name || !image || status === "" || category_id === "") {
                errorToast('All fields are required!');
                return;
            }

            let formData = new FormData();
            formData.append('name', name);
            formData.append('image', image);
            formData.append('status', status);
            formData.append('category_id', category_id);

            try {
                showLoader();
                let res = await axios.post("/brandStore", formData, {
                    headers: { 'Content-Type': 'multipart/form-data' }
                });
                hideLoader();

                if (res.status === 201) {
                    successToast('Brand created successfully!');
                    window.location.href = '/brand';
                } else {
                    errorToast("Request failed!");
                }
            } catch (error) {
                console.error("Error occurred while submitting the form: ", error);
                errorToast("An error occurred. Please try again.");
            }
        }

        // ✅ Load categories on page load
        document.addEventListener("DOMContentLoaded", loadCategories);
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH D:\backend\laravel\ecommerce\backend\resources\views/admin/brand/BrandCreate.blade.php ENDPATH**/ ?>