<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <p class="text-3xl font-bold text-gray-500">
            <span class="text-[#00FF7F]">Product</span> Create
        </p>
     <?php $__env->endSlot(); ?>

    <form id="save-form" class="w-[60%] m-auto border mt-5 py-6 px-6 rounded border-[#00FF7F]"
          onsubmit="event.preventDefault(); handleForm();">

        <!-- Name -->
        <input class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="text" id="name" name="name" placeholder="Product Name" required>

        <!-- Subtitle -->
        <input class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="text" id="subtitle" name="subtitle" placeholder="Product Subtitle" required>

        <!-- Description -->
        <textarea class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
                  id="description" name="description" placeholder="Product Description"></textarea>

        <!-- Price -->
        <input class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="number" step="0.01" id="price" name="price" placeholder="Price" required>

        <!-- Stock -->
        <input class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="number" id="stock" name="stock" placeholder="Stock Quantity" required>

        <!-- Discount -->
        <input class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="text" id="discount" name="discount" placeholder="Discount (optional)">

        <!-- Tag -->
        <select id="tag" name="tag"
                class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500">
            <option value="">Select Tag</option>
            <option value="Latest">Latest</option>
            <option value="Top Rating">Top Rating</option>
            <option value="Best Selling">Best Selling</option>
            <option value="Featured">Featured</option>
            <option value="Special">Special</option>
            <option value="Gift">Gift</option>
            <option value="Outher">Outher</option>
        </select>

        <!-- Category Dropdown -->
        <select id="category_id" name="category_id"
                class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
            <option value="">Select Category</option>
        </select>

        <!-- Brand Dropdown -->
        <select id="brand_id" name="brand_id"
                class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
            <option value="">Select Brand</option>
        </select>

        <!-- Image Upload Grid (4 slots) -->
        <div class="grid grid-cols-4 gap-6 mb-6">
            <?php for($i = 1; $i <= 4; $i++): ?>
                <div class="relative w-32 h-32 border border-[#00FF7F] rounded flex items-center justify-center bg-gray-900">
                    <img id="preview<?php echo e($i); ?>" class="absolute w-full h-full object-cover rounded" style="display:none;" />
                    <label for="image<?php echo e($i); ?>" class="cursor-pointer text-4xl text-[#00FF7F] z-10">+</label>
                    <input type="file" id="image<?php echo e($i); ?>" name="images[]" accept="image/*" class="hidden"
                           onchange="previewImage(this, 'preview<?php echo e($i); ?>')">
                </div>
            <?php endfor; ?>
        </div>

        <!-- Status -->
        <select id="status" name="status"
                class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
            <option value="1">Active</option>
            <option value="0">Inactive</option>
        </select>

        <!-- Submit -->
        <button type="submit"
                class="border py-2 px-4 bg-[#00FF7F] text-gray-500 font-bold rounded hover:bg-[#00FF7F]">
            Create
        </button>
    </form>

    <script>
        // ✅ Load categories and brands
        window.onload = async function () {
            await loadCategories();
            await loadBrands();
        };

        async function loadCategories() {
            try {
                let res = await axios.get("/categoryList");
                let categorySelect = document.getElementById("category_id");

                res.data.forEach(item => {
                    if (item.status === 1) {
                        let option = document.createElement("option");
                        option.value = item.id;
                        option.textContent = item.name;
                        categorySelect.appendChild(option);
                    }
                });
            } catch (error) {
                console.error("Failed to load categories:", error);
            }
        }

        async function loadBrands() {
            try {
                let res = await axios.get("/brandList");
                let brandSelect = document.getElementById("brand_id");

                res.data.forEach(item => {
                    if (item.status === 1) {
                        let option = document.createElement("option");
                        option.value = item.id;
                        option.textContent = item.name;
                        brandSelect.appendChild(option);
                    }
                });
            } catch (error) {
                console.error("Failed to load brands:", error);
            }
        }

        // ✅ Preview selected image
        function previewImage(input, previewId) {
            const file = input.files[0];
            const preview = document.getElementById(previewId);

            if (file) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    preview.src = e.target.result;
                    preview.style.display = "block";
                };
                reader.readAsDataURL(file);
            } else {
                preview.src = "";
                preview.style.display = "none";
            }
        }

        // ✅ Submit form with multiple images
        async function handleForm() {
            let formData = new FormData();
            formData.append('name', document.getElementById('name').value);
            formData.append('subtitle', document.getElementById('subtitle').value);
            formData.append('description', document.getElementById('description').value);
            formData.append('price', document.getElementById('price').value);
            formData.append('stock', document.getElementById('stock').value);
            formData.append('discount', document.getElementById('discount').value);
            formData.append('tag', document.getElementById('tag').value);
            formData.append('category_id', document.getElementById('category_id').value);
            formData.append('brand_id', document.getElementById('brand_id').value);
            formData.append('status', document.getElementById('status').value);

            // ✅ Append all 4 images
            ['image1', 'image2', 'image3', 'image4'].forEach(id => {
                const file = document.getElementById(id).files[0];
                if (file) {
                    formData.append('images[]', file);
                }
            });

            try {
                let res = await axios.post("/productStore", formData, {
                    headers: { 'Content-Type': 'multipart/form-data' }
                });

                if (res.status === 201) {
                    successToast('Product created successfully!');
                    window.location.href = '/product';
                } else {
                    errorToast("Request failed!");
                }
            } catch (error) {
                console.error("Error occurred while submitting the form: ", error);
                errorToast("An error occurred. Please try again.");
            }
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH D:\backend\laravel\ecommerce\backend\resources\views/admin/product/ProductCreate.blade.php ENDPATH**/ ?>