<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <p class="text-3xl font-bold text-gray-500">
            <span class="text-[#00FF7F]">Slider</span> Create
        </p>
     <?php $__env->endSlot(); ?>

    <form id="save-form" class="w-[60%] m-auto border mt-5 py-6 px-6 rounded border-[#00FF7F]"
          onsubmit="event.preventDefault(); handleForm();">

        <!-- title field -->
        <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="text" id="title" name="title" placeholder="Slider Title" required>

        <!-- subtitle field -->
        <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="text" id="subtitle" name="subtitle" placeholder="Slider Subtitle">

        <!-- link field -->
        <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="text" id="link" name="link" placeholder="Slider Link">

        <!-- Image field -->
        <input class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
               type="file" id="image" name="image" required>

        <!-- Category field -->
        <select id="category_id" name="category_id"
                class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
            <option value="">Select Category</option>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <!-- Status field -->
        <select id="status" name="status"
                class="block w-[100%] mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
            <option value="1">Active</option>
            <option value="0">Inactive</option>
        </select>

        <!-- Submit button -->
        <button type="submit"
                class="border py-2 px-4 bg-[#00FF7F] text-gray-500 font-bold rounded hover:bg-[#00FF7F]">
            Create
        </button>
    </form>

    <script>
        async function handleForm() {
            let title = document.getElementById('title').value;
            let subtitle = document.getElementById('subtitle').value;
            let link = document.getElementById('link').value;
            let image = document.getElementById('image').files[0];
            let category_id = document.getElementById('category_id').value;
            let status = document.getElementById('status').value;

            if (!title || !image || !category_id || status === "") {
                errorToast('Error: Required fields missing!');
                return;
            }

            let formData = new FormData();
            formData.append('title', title);
            formData.append('subtitle', subtitle);
            formData.append('link', link);
            formData.append('image', image);
            formData.append('category_id', category_id);
            formData.append('status', status);

            try {
                let res = await axios.post("/sliderStore", formData, {
                    headers: { 'Content-Type': 'multipart/form-data' }
                });

                if (res.status === 201) {
                    successToast('Slider created successfully!');
                    window.location.href = '/slider';
                } else {
                    errorToast("Request failed!");
                }
            } catch (error) {
                console.error("Error occurred while submitting the form: ", error);
                errorToast("An error occurred. Please try again.");
            }
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH D:\backend\laravel\ecommerce\backend\resources\views/admin/slider/SliderCreate.blade.php ENDPATH**/ ?>