<div class="modal animated zoomIn" id="update-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content bg-gray-800 text-white">
            <div class="modal-header border-b border-gray-700">
                <h5 class="modal-title text-gray-400" id="exampleModalLabel">
                    Update <span class="text-[#00FF7F]">Brand</span>
                </h5>
            </div>
            <div class="modal-body">
                <form id="update-form">
                    <div class="container">
                        <div class="row">
                            <form id="save-form" class="w-[50%] m-auto border mt-9 py-6 px-4 rounded bg-[#010116]">
                                <div class="mb-3">
                                    <input type="text" class="w-[100%] focus:border-[#00FF7F] border-[#00FF7F] rounded bg-transparent text-gray-400"
                                           id="name" name="name" placeholder="Brand Name" required>
                                </div>

                                <div class="mb-3">
                                    <div class="p-2 rounded">
                                        <img id="preview-image" src="" class="w-24 h-24 mb-4 border border-[#00FF7F] rounded" alt="Brand Image">
                                    </div>
                                    <input type="file" class="w-[100%] rounded bg-transparent text-gray-500"
                                           id="image" name="image" accept="image/*">
                                </div>

                                <div class="mb-3">
                                    <select id="status" name="status"
                                            class="w-[100%] rounded bg-transparent text-gray-400 border border-[#00FF7F]" required>
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>

                                <!-- ✅ Category Dropdown -->
                                <div class="mb-3">
                                    <select id="category_id" name="category_id"
                                            class="w-[100%] rounded bg-transparent text-gray-400 border border-[#00FF7F]" required>
                                        <!-- <option value="">Select Category</option> -->
                                    </select>
                                </div>

                                <input type="hidden" id="updateID">
                            </form>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer border-t border-gray-700">
                <button id="update-modal-close" class="btn bg-gradient-primary" data-bs-dismiss="modal" aria-label="Close">Close</button>
                <button onclick="Update()" id="update-btn" class="btn bg-[#00FF7F]">Update</button>
            </div>
        </div>
    </div>
</div>

<script>

// Category list লোড করার ফাংশন
async function loadCategories() {
    try {
        let res = await axios.get('/categoryList');
        let categories = res.data;

        let categorySelect = document.getElementById("category_id");
        categorySelect.innerHTML = '<option value="">Select Category</option>';

        categories.forEach(cat => {
            let option = document.createElement("option");
            option.value = cat.id;
            option.text = cat.name;
            categorySelect.appendChild(option);
        });
    } catch (error) {
        console.error("Failed to fetch categories", error);
    }
}

async function FillUpdateForm(id) {
    try {
        // প্রথমে category লোড করো
        await loadCategories();

        let res = await axios.get(`/editBrand/${id}`);
        let about = res.data;

        document.getElementById("name").value = about.name;
        document.getElementById("preview-image").src = about.image;
        document.getElementById("status").value = about.status;
        document.getElementById("updateID").value = about.id;

        // ✅ category select সেট করো
        document.getElementById("category_id").value = about.category_id;

    } catch (error) {
        console.error("Failed to fetch brand details", error);
    }
}

async function Update() {
    document.getElementById('update-modal-close').click();
    let updateID = document.getElementById('updateID').value;

    const formData = new FormData();
    formData.append('name', document.getElementById('name').value);
    formData.append('image', document.getElementById('image').files[0]);
    formData.append('status', document.getElementById('status').value);
    formData.append('category_id', document.getElementById('category_id').value);

    try {
        let res = await axios.post(`/updateBrand/${updateID}`, formData, {
            headers: { 'Content-Type': 'multipart/form-data' }
        });
        successToast('Brand updated successfully!');
        await getList();
        window.location.href = '/brand';
    } catch {
        errorToast('Brand Update failed!');
    }
}


</script>
<?php /**PATH D:\backend\laravel\ecommerce\backend\resources\views/admin/brand/BrandUpdate.blade.php ENDPATH**/ ?>