<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-md-12 col-sm-12 col-lg-12">
            <div class="px-5 py-5">
                <hr class="bg-secondary"/>
                <div class="table-responsive">
                    <table class="table" id="tableData">
                        <thead>
                        <tr class="bg-[#041819] text-white">
                            <th>No</th>
                            <th>Name</th>
                            <th>Sub Title</th>
                            <th>Description</th>
                            <th>Price</th>
                            <th>Stock</th>
                            <th>Discount</th>
                            <th>Tag</th>
                            <th>Category</th>
                            <th>Brand</th>
                            <th>Images</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody id="tableList"></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.switch {
  position: relative;
  display: inline-block;
  width: 50px;
  height: 24px;
}
.switch input {
  opacity: 0;
  width: 0;
  height: 0;
}
.slider {
  position: absolute;
  cursor: pointer;
  top: 0; left: 0;
  right: 0; bottom: 0;
  background-color: #ccc;
  transition: .4s;
  border-radius: 24px;
}
.slider:before {
  position: absolute;
  content: "";
  height: 18px; width: 18px;
  left: 3px; bottom: 3px;
  background-color: white;
  transition: .4s;
  border-radius: 50%;
}
input:checked + .slider {
  background-color: #00FF7F;
}
input:checked + .slider:before {
  transform: translateX(26px);
}
.status-label {
  font-size: 12px;
  margin-left: 8px;
  font-weight: bold;
  color: #888;
}
.status-label.active {
  color: #00FF7F;
}
.status-label.inactive {
  color: #FF4C4C;
}
</style>

<script>
getList();

async function getList() {
    let res = await axios.get("/productList");
    let tableList = $("#tableList");
    let tableData = $("#tableData");

    tableData.DataTable().destroy();
    tableList.empty();

    // ✅ Category Map
    let categoryMap = {};
    let categoryRes = await axios.get("/categoryList");
    categoryRes.data.forEach(cat => {
        if (cat.status === 1) {
            categoryMap[cat.id] = cat.name;
        }
    });

    // ✅ Brand Map
    let brandMap = {};
    let brandRes = await axios.get("/brandList");
    brandRes.data.forEach(brand => {
        if (brand.status === 1) {
            brandMap[brand.id] = brand.name;
        }
    });

    res.data.forEach(function (item, index) {
        // ✅ Status
        let statusValue = item['status'] === 1 ? 'Active' : 'Inactive';
        let isChecked = statusValue === 'Active' ? 'checked' : '';
        let statusText = statusValue === 'Active' ? 'Visible to Clients' : 'Hidden from Clients';
        let statusClass = statusValue === 'Active' ? 'active' : 'inactive';

        // ✅ Decode images JSON
        let images = [];
        try {
            images = JSON.parse(item['images'] || "[]");
        } catch (e) {
            images = [];
        }

        // ✅ Build auto slider HTML
        let sliderHtml = "";
        if (images.length > 0) {
            sliderHtml = `
            <div id="carousel-${item['id']}" class="carousel slide" data-bs-ride="carousel" data-bs-interval="2000" style="max-width:120px;">
                <div class="carousel-inner">
                    ${images.map((img, i) => `
                        <div class="carousel-item ${i === 0 ? 'active' : ''}">
                            <img src="${img}" class="d-block w-100" style="max-height:100px; object-fit:cover;" alt="Product Image">
                        </div>
                    `).join('')}
                </div>
            </div>`;
        } else {
            sliderHtml = `<span class="text-muted">No Image</span>`;
        }

        // ✅ Row HTML
        let row = `<tr data-id="${item['id']}">
            <td>${index + 1}</td>
            <td class="text-wrap">${item['name']}</td>
            <td class="text-wrap">${item['subtitle']}</td>
            <td class="text-wrap">${item['description']}</td>
            <td class="text-wrap">${item['price']}</td>
            <td class="text-wrap">${item['stock']}</td>
            <td class="text-wrap">${item['discount']}</td>
            <td class="text-wrap">${item['tag']}</td>
            <td class="text-wrap">${categoryMap[item['category_id']] || 'Unknown'}</td>
            <td class="text-wrap">${brandMap[item['brand_id']] || 'Unknown'}</td>
            <td>${sliderHtml}</td>
            <td>
                <label class="switch">
                    <input type="checkbox" ${isChecked} onchange="toggleStatus(this, ${item['id']})">
                    <span class="slider round"></span>
                </label>
                <span class="status-label ${statusClass}" id="status-label-${item['id']}">${statusText}</span>
            </td>
            <td>
                <button data-id="${item['id']}" onclick="FillUpdateForm(${item['id']})" class="btn editBtn btn-sm btn-outline-success">Edit</button>
                <button data-id="${item['id']}" class="btn deleteBtn btn-sm btn-outline-danger">Delete</button>
            </td>
        </tr>`;
        tableList.append(row);
    });

    // ✅ Edit/Delete button actions
    $('.editBtn').on('click', async function () {
        let id = $(this).data('id');
        $('#updateID').val(id);
        $('#update-modal').modal('show');
    });

    $('.deleteBtn').on('click', function () {
        let id = $(this).data('id');
        $('#delete-modal').modal('show');
        $('#deleteID').val(id);
    });

    // ✅ DataTable init
    new DataTable('#tableData', {
        order: [[0, 'asc']],
        lengthMenu: [5, 10, 15, 20, 30]
    });
}

async function toggleStatus(checkbox, id) {
    let isActive = checkbox.checked;

    // Update status label text and color
    let label = document.getElementById(`status-label-${id}`);
    label.textContent = isActive ? 'Visible to Clients' : 'Hidden from Clients';
    label.classList.toggle('active', isActive);
    label.classList.toggle('inactive', !isActive);

    // Update status via API
    try {
        await axios.post('/updateProductStatus', {
            id: id,
            status: isActive ? 1 : 0
        });
    } catch (error) {
        console.error('Status update failed:', error);
    }
}
</script><?php /**PATH D:\backend\laravel\ecommerce\backend\resources\views/admin/product/ProductList.blade.php ENDPATH**/ ?>