<div class="modal animated zoomIn" id="update-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content bg-gray-800 text-white">
            <div class="modal-header border-b border-gray-700">
                <h5 class="modal-title text-gray-400" id="exampleModalLabel">
                    Update <span class="text-[#00FF7F]">Blog</span>
                </h5>
            </div>
            <div class="modal-body">
                <form id="update-form">
                    <div class=" m-auto border  py-6 px-4 rounded bg-[#010116]">
                        <!-- Blog Name -->
                        <div class="mb-3">
                            <input type="text" id="name" name="name"
                                   class="w-full focus:border-[#00FF7F] border-[#00FF7F] rounded bg-transparent text-gray-400"
                                   placeholder="Blog Name" required>
                        </div>

                        <!-- Blog Title -->
                        <div class="mb-3">
                            <input type="text" id="title" name="title"
                                   class="w-full focus:border-[#00FF7F] border-[#00FF7F] rounded bg-transparent text-gray-400"
                                   placeholder="Blog Title" required>
                        </div>

                        <!-- Descriptions -->
                        <div class="mb-3">
                            <label class="text-sm text-gray-400 mb-2 block">Descriptions</label>
                            <div id="update-descriptions-container" class="space-y-3">
                                <!-- JS will fill this -->
                            </div>
                            <button type="button" onclick="addUpdateDescription()"
                                    class="text-[#00FF7F] text-sm font-medium hover:underline mt-2">+ Add More Descriptions</button>
                        </div>

                        <!-- Image Preview -->
                        <div class="mb-3">
                            <div class="p-2 rounded">
                                <img id="preview-image" src="" class="w-24 h-24 mb-4 border border-[#00FF7F] rounded" alt="Blog Image">
                            </div>
                            <input type="file" id="image" name="image" accept="image/*"
                                   class="w-full rounded bg-transparent text-gray-500">
                        </div>

                        <!-- Status -->
                        <div class="mb-3">
                            <select id="status" name="status"
                                    class="w-full rounded bg-transparent text-gray-400 border border-[#00FF7F]" required>
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>

                        <input type="hidden" id="updateID">
                    </div>
                </form>
            </div>
            <div class="modal-footer border-t border-gray-700">
                <button id="update-modal-close" class="btn bg-gradient-primary" data-bs-dismiss="modal" aria-label="Close">Close</button>
                <button onclick="UpdateBlog()" id="update-btn" class="btn bg-[#00FF7F]">Update</button>
            </div>
        </div>
    </div>
</div>

<script>
function addUpdateDescription(value = '') {
    const container = document.getElementById('update-descriptions-container');
    const textarea = document.createElement('textarea');
    textarea.name = 'descriptions[]';
    textarea.className = 'w-full px-4 py-2 bg-transparent border border-gray-600 rounded text-gray-200';
    textarea.placeholder = 'Description';
    textarea.value = value;
    container.appendChild(textarea);
}

async function FillUpdateForm(id) {
    try {
        let res = await axios.get(`/editBlog/${id}`);
        let blog = res.data;

        document.getElementById("name").value = blog.name || '';
        document.getElementById("title").value = blog.title || '';
        document.getElementById("preview-image").src = blog.image || '';
        document.getElementById("status").value = blog.status ?? '1';
        document.getElementById("updateID").value = blog.id;

        const container = document.getElementById('update-descriptions-container');
        container.innerHTML = '';

        if (Array.isArray(blog.descriptions) && blog.descriptions.length > 0) {
            blog.descriptions.forEach(desc => addUpdateDescription(desc));
        } else {
            addUpdateDescription('');
        }

    } catch (error) {
        console.error("Failed to fetch blog details", error);
        errorToast("Could not load blog data");
    }
}

async function UpdateBlog() {
    document.getElementById('update-modal-close').click();
    let updateID = document.getElementById('updateID').value;

    const formData = new FormData();
    formData.append('name', document.getElementById('name').value);
    formData.append('title', document.getElementById('title').value);
    formData.append('status', document.getElementById('status').value);

    const descriptions = document.querySelectorAll('#update-descriptions-container textarea');
    descriptions.forEach(d => formData.append('descriptions[]', d.value));

    const imageInput = document.getElementById('image');
    if (imageInput.files.length > 0) {
        formData.append('image', imageInput.files[0]);
    }

    try {
        let res = await axios.post(`/updateBlog/${updateID}`, formData, {
            headers: { 'Content-Type': 'multipart/form-data' }
        });
        successToast('Blog updated successfully!');
        await getList();
        window.location.href = '/blog';
    } catch {
        errorToast('Blog update failed!');
    }
}

</script><?php /**PATH D:\backend\laravel\ecommerce\backend\resources\views/admin/blog/BlogUpdate.blade.php ENDPATH**/ ?>