<div class="modal animated zoomIn" id="update-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-md modal-dialog-centered">
    <div class="modal-content bg-gray-800 text-white">
      <div class="modal-header border-b border-gray-700">
        <h5 class="modal-title text-gray-400" id="exampleModalLabel">
          Update <span class="text-[#00FF7F]">Product</span>
        </h5>
      </div>
      <div class="modal-body">
        <form id="update-form" class="w-full m-auto border py-6 px-4 rounded bg-[#010116]">
          <!-- Name -->
          <input class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
                 type="text" id="name" name="name" placeholder="Product Name" required>

          <!-- Subtitle -->
          <input class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
                 type="text" id="subtitle" name="subtitle" placeholder="Product Subtitle" required>

          <!-- Description -->
          <textarea class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
                    id="description" name="description" placeholder="Product Description"></textarea>

          <!-- Price -->
          <input class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
                 type="number" step="0.01" id="price" name="price" placeholder="Price" required>

          <!-- Stock -->
          <input class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
                 type="number" id="stock" name="stock" placeholder="Stock Quantity" required>

          <!-- Discount -->
          <input class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500"
                 type="number" id="discount" name="discount" placeholder="Discount (%)">

          <!-- Tag -->
          <select id="tag" name="tag"
                  class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500">
            <option value="">Select Tag</option>
            <option value="Latest">Latest</option>
            <option value="Top Rating">Top Rating</option>
            <option value="Best Selling">Best Selling</option>
            <option value="Featured">Featured</option>
            <option value="Special">Special</option>
            <option value="Gift">Gift</option>
            <option value="Outher">Outher</option>
          </select>

          <!-- Category Dropdown -->
          <select id="category_id" name="category_id"
                  class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
            <option value="">Select Category</option>
          </select>

          <!-- Brand Dropdown -->
          <select id="brand_id" name="brand_id"
                  class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
            <option value="">Select Brand</option>
          </select>

          <!-- Images -->
          <div class="grid grid-cols-4 gap-6 mb-6">
            <?php for($i = 1; $i <= 4; $i++): ?>
              <div class="relative w-24 h-24 border border-[#00FF7F] rounded flex items-center justify-center bg-gray-900">
                <img id="preview<?php echo e($i); ?>" class="absolute w-full h-full object-cover rounded" style="display:none;" />
                <label for="image<?php echo e($i); ?>" class="cursor-pointer text-4xl text-[#00FF7F] z-10">+</label>
                <input type="file" id="image<?php echo e($i); ?>" name="images[]" accept="image/*" class="hidden"
                       onchange="previewImage(this, 'preview<?php echo e($i); ?>')">
              </div>
            <?php endfor; ?>
          </div>

          <!-- Status -->
          <select id="status" name="status"
                  class="block w-full mb-4 bg-transparent rounded focus:border-[#00FF7F] text-gray-500" required>
            <option value="1">Active</option>
            <option value="0">Inactive</option>
          </select>

          <input type="hidden" id="updateID">
        </form>
      </div>
      <div class="modal-footer border-t border-gray-700">
        <button id="update-modal-close" class="btn bg-gradient-primary" data-bs-dismiss="modal" aria-label="Close">Close</button>
        <button onclick="Update()" id="update-btn" class="btn bg-[#00FF7F]">Update</button>
      </div>
    </div>
  </div>
</div>


<script>

 window.onload = async function () {
            await loadCategories();
            await loadBrands();
        };

       async function loadCategories() {
    try {
        let res = await axios.get("/categoryList");
        let categorySelect = document.getElementById("category_id");

        res.data.forEach(item => {
            if (item.status === 1) { // ✅ Only show active categories
                let option = document.createElement("option");
                option.value = item.id;
                option.textContent = item.name;
                categorySelect.appendChild(option);
            }
        });
    } catch (error) {
        console.error("Failed to load categories:", error);
    }
    }

    async function loadBrands() {
        try {
            let res = await axios.get("/brandList");
            let brandSelect = document.getElementById("brand_id");

            res.data.forEach(item => {
                if (item.status === 1) { // ✅ Only show active brands
                    let option = document.createElement("option");
                    option.value = item.id;
                    option.textContent = item.name;
                    brandSelect.appendChild(option);
                }
            });
        } catch (error) {
            console.error("Failed to load brands:", error);
        }
    }


async function FillUpdateForm(id) {
  try {
    let res = await axios.get(`/editProduct/${id}`);
    let about = res.data;

    document.getElementById("name").value = about.name;
    document.getElementById("subtitle").value = about.subtitle;
    document.getElementById("description").value = about.description;
    document.getElementById("price").value = about.price;
    document.getElementById("stock").value = about.stock;
    document.getElementById("discount").value = about.discount;
    document.getElementById("tag").value = about.tag;
    document.getElementById("category_id").value = about.category_id;
    document.getElementById("brand_id").value = about.brand_id;
    document.getElementById("status").value = about.status;
    document.getElementById("updateID").value = about.id;

    // যদি পুরনো image থাকে, preview-তে দেখাও
    if (about.images && Array.isArray(about.images)) {
      about.images.forEach((img, index) => {
        const preview = document.getElementById(`preview${index+1}`);
        if (preview) {
          preview.src = img;
          preview.style.display = "block";
        }
      });
    }
  } catch (error) {
    console.error("Failed to fetch product details", error);
  }
}

// ✅ Preview selected image
function previewImage(input, previewId) {
  const file = input.files[0];
  const preview = document.getElementById(previewId);

  if (file) {
    const reader = new FileReader();
    reader.onload = function (e) {
      preview.src = e.target.result;
      preview.style.display = "block";
    };
    reader.readAsDataURL(file);
  } else {
    preview.src = "";
    preview.style.display = "none";
  }
}

async function Update() {
  document.getElementById('update-modal-close').click();
  let updateID = document.getElementById('updateID').value;

  const formData = new FormData();
  formData.append('name', document.getElementById('name').value);
  formData.append('subtitle', document.getElementById('subtitle').value);
  formData.append('description', document.getElementById('description').value);
  formData.append('price', document.getElementById('price').value);
  formData.append('stock', document.getElementById('stock').value);
  formData.append('discount', document.getElementById('discount').value);
  formData.append('tag', document.getElementById('tag').value);
  formData.append('category_id', document.getElementById('category_id').value);
  formData.append('brand_id', document.getElementById('brand_id').value);

  // ✅ Append all 4 images
  ['image1', 'image2', 'image3', 'image4'].forEach(id => {
    const file = document.getElementById(id).files[0];
    if (file) {
      formData.append('images[]', file);
    }
  });

  formData.append('status', document.getElementById('status').value);

  try {
    let res = await axios.post(`/updateProduct/${updateID}`, formData, {
      headers: { 'Content-Type': 'multipart/form-data' }
    });

    successToast('Product updated successfully!');
    await getList();
    window.location.href = '/product';
  } catch (error) {
    console.error("Update failed:", error);
    errorToast('Product update failed!');
  }
}



</script>
<?php /**PATH D:\backend\laravel\ecommerce\backend\resources\views/admin/product/ProductUpdate.blade.php ENDPATH**/ ?>